"use client";
import React from "react";
import ProductCard from "@/components/Common/Card/ProductCard";
import { useSellerProductsQuery } from "@/store/features/seller/apiSlice";
import SvgLoader from "@/components/Helper/Loader/SvgLoader";
import PaginateObserver from "@/components/Helper/PaginateObserver";
import { useDispatch, useSelector } from "react-redux";
import { sellerProductPageIncrease } from "@/store/features/pagination/paginationSlice";
import StringLang from "@/utilities/StringLang";

function SellerProfile({ datas }) {
  const dispatch = useDispatch();
  const page = useSelector((state) => state.pagination.sellerProductPage);

  const paginationHandler = () => {
    dispatch(sellerProductPageIncrease());
  };

  const { data, isFetching } = useSellerProductsQuery({
    page: page,
    userName: datas?.author?.user_name,
  });

  if (!datas || !datas.author) return null;

  const { author, total_sale, total_review, average_rating } = datas;

  // ✅ ADMIN MANUAL VALUES
  const manualTotalSales = author.manual_total_sales;
  const manualRating = author.manual_rating;
  const manualDeliveryTime = author.manual_delivery_time;

  // ✅ ONE SINGLE RATING SOURCE (USED EVERYWHERE)
  const finalRating =
    manualRating !== null && manualRating !== undefined
      ? manualRating
      : average_rating ?? 0;

  return (
    <>
      <div className="w-full mt-11 pb-[100px]">
        <div className="theme-container mx-auto">
          <div className="w-full lg:px-[190px]">
            {/* Seller Profile Info */}
            <div className="w-full bg-black px-[29px] py-10 rounded-lg mb-[30px]">
              <div className="w-full flex md:flex-row flex-col space-y-5 md:space-y-0 md:justify-between md:items-center items-start mb-[30px]">
                <div className="md:flex md:rtl:space-x-reverse space-x-4">
                  <div className="w-[100px] h-[100px] rounded-full overflow-hidden mb-3 md:mb-0">
                    <img
                      src={process.env.BASE_URL + author.image}
                      alt=""
                      className="w-full h-full object-cover"
                    />
                  </div>

                  <div>
                    {/* Seller Name */}
                    <div className="flex rtl:space-x-reverse space-x-2 mt-3">
                      <h1 className="text-white text-xl font-bold notranslate">
                        {author.name}
                      </h1>
                    </div>

                    {/* ✅ FIXED HEADER RATING */}
                    <div className="flex rtl:space-x-reverse space-x-1.5 items-center mt-2.5">
                      <span>⭐</span>
                      <span className="text-lg text-white font-semibold">
                        {finalRating}
                      </span>
                    </div>
                  </div>
                </div>
              </div>

              {/* ✅ 3 STATS CARDS */}
              <div className="grid sm:grid-cols-3 grid-cols-1 gap-5 mb-[30px]">
                {/* ✅ Total Sales */}
                <div className="w-full h-[120px] bg-[#0B0E13] flex items-center px-5 rounded-md">
                  <div className="flex rtl:space-x-reverse space-x-[14px]">
                    <div className="w-[48px] h-[48px] rounded-full flex justify-center items-center bg-primary-blue/20">
                      <span className="text-primary-blue">🛒</span>
                    </div>
                    <div>
                      <p className="text-lg leading-7">
                        <StringLang string="Total Sales" />
                      </p>

                      <p className="text-2xl font-semibold text-white">
                        {manualTotalSales !== null &&
                        manualTotalSales !== undefined
                          ? manualTotalSales
                          : total_sale ?? 0}
                      </p>
                    </div>
                  </div>
                </div>

                {/* ✅ Overall Ratings (FIXED) */}
                <div className="w-full h-[120px] bg-[#0B0E13] flex items-center px-5 rounded-md">
                  <div className="flex rtl:space-x-reverse space-x-[14px]">
                    <div className="w-[48px] h-[48px] rounded-full flex justify-center items-center bg-primary-blue/20">
                      <span className="text-primary-blue">⭐</span>
                    </div>
                    <div>
                      <p className="text-lg leading-7">
                        <StringLang string="Overall ratings" />
                      </p>
                      <p className="text-2xl font-semibold text-white">
                        {finalRating}
                      </p>
                    </div>
                  </div>
                </div>

                {/* ✅ Delivery Time */}
                <div className="w-full h-[120px] bg-[#0B0E13] flex items-center px-5 rounded-md">
                  <div className="flex rtl:space-x-reverse space-x-[14px]">
                    <div className="w-[48px] h-[48px] rounded-full flex justify-center items-center bg-primary-blue/20">
                      <span className="text-primary-blue">⏱</span>
                    </div>
                    <div>
                      <p className="text-lg leading-7">
                        <StringLang string="Time" />
                      </p>

                      <p className="text-2xl font-semibold text-white">
                        {manualDeliveryTime ?? "Instant"}
                      </p>
                    </div>
                  </div>
                </div>
              </div>

              {/* ✅ About Seller */}
              <h2 className="text-2xl font-bold leading-8 text-white mb-3.5">
                <StringLang string="About Seller" />
              </h2>

              <p
                className="text-base leading-6"
                dangerouslySetInnerHTML={{
                  __html: author?.about_me?.replace(/<[^>]*>/g, ""),
                }}
              ></p>
            </div>

            {/* ✅ Seller Products */}
            <p className="text-2xl font-bold text-white mb-4">
              <StringLang string="Seller Products" />
            </p>

            {data && data?.products && data?.products?.data.length > 0 ? (
              <PaginateObserver
                currentPage={page}
                lastPage={data?.products?.last_page}
                loading={isFetching}
                handler={paginationHandler}
                type="onclick"
              >
                <div className="grid xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-6 mb-[30px]">
                  {data.products.data.map((product, i) => (
                    <ProductCard {...product} key={i} />
                  ))}
                </div>
              </PaginateObserver>
            ) : isFetching ? (
              <div className="flex justify-center">
                <SvgLoader />
              </div>
            ) : (
              <div className="mt-5 flex justify-center">
                <span className="text-sm text-primary-black">
                  <StringLang string="No Products Found!" />
                </span>
              </div>
            )}
          </div>
        </div>
      </div>
    </>
  );
}

export default SellerProfile;
