import React from "react";

function CounterSection({ datas }) {
  // Helper function for formatting
  const formatNumber = (num) => {
    if (num === null || num === undefined) return 0;
    if (num < 1000) return num;
    if (num < 1000000) return (num / 1000).toFixed(1).replace(/\.0$/, "") + "K";
    if (num < 1000000000)
      return (num / 1000000).toFixed(1).replace(/\.0$/, "") + "M";
    return (num / 1000000000).toFixed(1).replace(/\.0$/, "") + "B";
  };

  if (!datas) return null;

  return (
    <div className="w-full pt-[60px]">
      <div className="w-full h-[204px] bg-primary-blue">
        <div className="theme-container mx-auto h-full">
          <div className="w-full h-full flex justify-between flex-wrap items-center gap-5">

            {/* Counter 1 */}
            <div className="flex flex-col lg:space-y-3 rtl:space-x-reverse space-x-1">
              <span className="text-primary-black lg:text-[65px] font-semibold tracking-wider lg:leading-[65px] text-3xl">
                {formatNumber(datas.counter1_value)}
              </span>
              <span className="text-primary-black text-lg">
                {datas.counter1_title}
              </span>
            </div>

            {/* Counter 2 */}
            <div className="flex flex-col lg:space-y-3 rtl:space-x-reverse space-x-1">
              <span className="text-primary-black lg:text-[65px] font-semibold tracking-wider lg:leading-[65px] text-3xl">
                {formatNumber(datas.counter2_value)}
              </span>
              <span className="text-primary-black text-lg">
                {datas.counter2_title}
              </span>
            </div>

            {/* Counter 3 */}
            <div className="flex flex-col lg:space-y-3 rtl:space-x-reverse space-x-1">
              <span className="text-primary-black lg:text-[65px] font-semibold tracking-wider lg:leading-[65px] text-3xl">
                {formatNumber(datas.counter3_value)}
              </span>
              <span className="text-primary-black text-lg">
                {datas.counter3_title}
              </span>
            </div>

            {/* Counter 4 */}
            <div className="flex flex-col lg:space-y-3 rtl:space-x-reverse space-x-1">
              <span className="text-primary-black lg:text-[65px] font-semibold tracking-wider lg:leading-[65px] text-3xl">
                {formatNumber(datas.counter4_value)}
              </span>
              <span className="text-primary-black text-lg">
                {datas.counter4_title}
              </span>
            </div>

          </div>
        </div>
      </div>
    </div>
  );
}

export default CounterSection;
