import { apiSlice } from "../../api/apiSlice";

export const reviewListApi = apiSlice.injectEndpoints({
  endpoints: (builder) => ({
    reviewList: builder.query({
      query: ({ id, page }) => {
        // ✅ Just return the relative path — base URL already handled by apiSlice
        return {
          url: `/product-review-list/${id}?lang_code=en&page=${page}`,
          method: "GET",
        };
      },
      serializeQueryArgs: ({ endpointName }) => endpointName,
      merge: (currentCache, newItems) => {
        if (newItems?.reviews?.current_page > 1) {
          currentCache.reviews.data.push(...newItems.reviews.data);
          currentCache.reviews.current_page = newItems.reviews.current_page;
          currentCache.reviews.last_page = newItems.reviews.last_page;
        } else {
          currentCache.reviews = newItems.reviews;
        }
      },
      forceRefetch({ currentArg, previousArg }) {
        return currentArg?.page !== previousArg?.page;
      },
    }),
  }),
});

// ✅ Correct export
export const { useReviewListQuery } = reviewListApi;
