<?php

set_time_limit(0);

$baseUrl = 'https://roy-shop.de';
$outputFile = _DIR_ . '/sitemap.xml';

$visited = [];
$toVisit = [$baseUrl];
$urls = [];

function curlGet($url)
{
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_USERAGENT => 'RoyShop-SitemapBot'
    ]);
    $html = curl_exec($ch);
    curl_close($ch);
    return $html;
}

while ($toVisit) {
    $url = array_shift($toVisit);
    if (isset($visited[$url])) continue;
    $visited[$url] = true;

    $html = curlGet($url);
    if (!$html) continue;

    $urls[] = $url;

    preg_match_all('/href=["\']([^"\']+)["\']/', $html, $matches);

    foreach ($matches[1] as $link) {
        if (strpos($link, $baseUrl) !== 0) continue;
        if (preg_match('#/(auth|cart|checkout|profile)#', $link)) continue;
        if (strpos($link, '?') !== false) continue;
        if (!isset($visited[$link])) {
            $toVisit[] = rtrim($link, '/');
        }
    }
}

/* ===== GENERATE XML ===== */

$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
$xml .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";

foreach (array_unique($urls) as $loc) {
    $xml .= "  <url>\n";
    $xml .= "    <loc>{$loc}</loc>\n";
    $xml .= "    <lastmod>" . date('Y-m-d') . "</lastmod>\n";
    $xml .= "    <changefreq>daily</changefreq>\n";
    $xml .= "    <priority>0.8</priority>\n";
    $xml .= "  </url>\n";
}

$xml .= "</urlset>";

file_put_contents($outputFile, $xml);

echo "Sitemap generated successfully\n";