import resolveLocale from './resolveLocale.js';
import { addLocaleData, getLocaleData } from './LocaleDataStore.js';
describe('resolveLocale', function () {
  it('should resolve locale', function () {
    // console.log()
    resolveLocale("EN").should.equal("en");
    resolveLocale("en-XX").should.equal("en");
    resolveLocale("ar-AE-oed").should.equal("ar-AE");
  });
  it('should throw when "localeMatcher" option is not a valid one', function () {
    expect(function () {
      return resolveLocale("en", {
        localeMatcher: "eccentric"
      });
    }).to["throw"]('Invalid "localeMatcher" option');
  });
  it('should fall back to "lookup" when passed "best fit" "localeMatcher" option', function () {
    resolveLocale("en-XX", {
      localeMatcher: "best fit"
    }).should.equal("en");
  });
});
//# sourceMappingURL=resolveLocale.test.js.map