import PluralRules from './PluralRules.js';
describe('Intl.PluralRules', function () {
  it('should validate "locales" argument', function () {
    expect(function () {
      return new PluralRules('xx');
    }).to["throw"]('Unsupported locale');
  });
  it('should validate "locale" format', function () {
    expect(function () {
      return new PluralRules('-en');
    }).to["throw"]('Invalid locale');
  });
  it('should validate "type" option', function () {
    expect(function () {
      return new PluralRules('en', {
        type: 'ordinal'
      });
    }).to["throw"]('Only "cardinal" "type" is supported');
  });
  it('should quantify numbers', function () {
    expect(new PluralRules('en').select(0)).to.equal('other');
    expect(new PluralRules('en').select(1)).to.equal('one');
  });
  it('should use supported locales', function () {
    expect(new PluralRules('en-US-POSIX').select(0)).to.equal('other');
    expect(new PluralRules('en-US-POSIX').select(1)).to.equal('one');
  });
  it('should return supported locales of', function () {
    expect(PluralRules.supportedLocalesOf('ru-RU-Cyrl')).to.deep.equal(['ru-RU-Cyrl']);
    expect(PluralRules.supportedLocalesOf(['ru-RU-Cyrl'])).to.deep.equal(['ru-RU-Cyrl']);
  });
});
//# sourceMappingURL=PluralRules.test.js.map