"use strict";

var _resolveLocale = _interopRequireDefault(require("./resolveLocale.js"));
var _LocaleDataStore = require("./LocaleDataStore.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
describe('resolveLocale', function () {
  it('should resolve locale', function () {
    // console.log()
    (0, _resolveLocale["default"])("EN").should.equal("en");
    (0, _resolveLocale["default"])("en-XX").should.equal("en");
    (0, _resolveLocale["default"])("ar-AE-oed").should.equal("ar-AE");
  });
  it('should throw when "localeMatcher" option is not a valid one', function () {
    expect(function () {
      return (0, _resolveLocale["default"])("en", {
        localeMatcher: "eccentric"
      });
    }).to["throw"]('Invalid "localeMatcher" option');
  });
  it('should fall back to "lookup" when passed "best fit" "localeMatcher" option', function () {
    (0, _resolveLocale["default"])("en-XX", {
      localeMatcher: "best fit"
    }).should.equal("en");
  });
});
//# sourceMappingURL=resolveLocale.test.js.map