"use strict";

var _PluralRules = _interopRequireDefault(require("./PluralRules.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
describe('Intl.PluralRules', function () {
  it('should validate "locales" argument', function () {
    expect(function () {
      return new _PluralRules["default"]('xx');
    }).to["throw"]('Unsupported locale');
  });
  it('should validate "locale" format', function () {
    expect(function () {
      return new _PluralRules["default"]('-en');
    }).to["throw"]('Invalid locale');
  });
  it('should validate "type" option', function () {
    expect(function () {
      return new _PluralRules["default"]('en', {
        type: 'ordinal'
      });
    }).to["throw"]('Only "cardinal" "type" is supported');
  });
  it('should quantify numbers', function () {
    expect(new _PluralRules["default"]('en').select(0)).to.equal('other');
    expect(new _PluralRules["default"]('en').select(1)).to.equal('one');
  });
  it('should use supported locales', function () {
    expect(new _PluralRules["default"]('en-US-POSIX').select(0)).to.equal('other');
    expect(new _PluralRules["default"]('en-US-POSIX').select(1)).to.equal('one');
  });
  it('should return supported locales of', function () {
    expect(_PluralRules["default"].supportedLocalesOf('ru-RU-Cyrl')).to.deep.equal(['ru-RU-Cyrl']);
    expect(_PluralRules["default"].supportedLocalesOf(['ru-RU-Cyrl'])).to.deep.equal(['ru-RU-Cyrl']);
  });
});
//# sourceMappingURL=PluralRules.test.js.map