"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _PluralRuleFunctions = _interopRequireDefault(require("./PluralRuleFunctions.js"));
var _getPluralRulesLocale = _interopRequireDefault(require("./getPluralRulesLocale.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } // Importing `PluralRule` polyfill from a separate package
// results in a bundle that is larger by 1kB for some reason.
// export { default as default } from 'intl-plural-rules-polyfill/cardinal'
/**
 * `Intl.PluralRules` polyfill.
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules
 */
var PluralRules = exports["default"] = /*#__PURE__*/function () {
  function PluralRules(locale, options) {
    _classCallCheck(this, PluralRules);
    var locales = PluralRules.supportedLocalesOf(locale);
    if (locales.length === 0) {
      throw new RangeError("Unsupported locale: " + locale);
    }
    if (options && options.type !== "cardinal") {
      throw new RangeError("Only \"cardinal\" \"type\" is supported");
    }
    this.$ = _PluralRuleFunctions["default"][(0, _getPluralRulesLocale["default"])(locales[0])];
  }
  _createClass(PluralRules, [{
    key: "select",
    value: function select(number) {
      return this.$(number);
    }
  }], [{
    key: "supportedLocalesOf",
    value: function supportedLocalesOf(locales) {
      if (typeof locales === "string") {
        locales = [locales];
      }
      return locales.filter(function (locale) {
        return _PluralRuleFunctions["default"][(0, _getPluralRulesLocale["default"])(locale)];
      });
    }
  }]);
  return PluralRules;
}();
//# sourceMappingURL=PluralRules.js.map