import TimeAgo from 'javascript-time-ago';
import Cache from './cache.js';
var TimeAgoCache = new Cache();
export default function getTimeAgo(preferredLocales, _ref) {
  var polyfill = _ref.polyfill;
  // `TimeAgo` instance creation is (hypothetically) assumed
  // a lengthy operation so the instances are cached and reused.
  // https://gitlab.com/catamphetamine/react-time-ago/-/issues/1
  var key = String(preferredLocales) + ':' + String(polyfill);
  return TimeAgoCache.get(key) || TimeAgoCache.put(key, new TimeAgo(preferredLocales, {
    polyfill: polyfill
  }));
}
//# sourceMappingURL=getTimeAgo.js.map