import { getDate } from './date.js';
describe('helpers/date', function () {
  it('should convert Date/number to Date', function () {
    var today = new Date();
    expect(getDate(today.getTime()).getTime()).to.equal(today.getTime());
    expect(getDate(today).getTime()).to.equal(today.getTime());
  });
  it('should support mocked Dates when testing', function () {
    var mockedDate = {
      getTime: function getTime() {
        return Date.now();
      }
    };
    expect(getDate(mockedDate)).to.equal(mockedDate);
  });
});
//# sourceMappingURL=date.test.js.map