function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Manages the updates of all `<ReactTimeAgo/>` elements on a page.
// The reasons for going with `requestAnimationFrame()`:
// * `requestAnimationFrame` won't be called when a tab is in background.
// * Chrome has bugs when handling `setTimeout()`: https://www.npmjs.com/package/request-animation-frame-timeout
// `requestAnimationFrame()` polyfill for old browsers.
import requestAnimationFrame from 'raf';
import binarySearch from './helpers/binarySearch.js';
export default {
  instances: [],
  add: function add(instance) {
    var _this = this;

    var wasIdle = this.instances.length === 0;

    _add(this.instances, instance);

    if (wasIdle) {
      this.start();
    }

    return {
      stop: function stop() {
        remove(_this.instances, instance);

        if (_this.instances.length === 0) {
          _this.stop();
        }
      },
      forceUpdate: function forceUpdate() {
        updateInstance(instance, _this.instances);
      }
    };
  },
  tick: function tick() {
    var now = Date.now();

    while (true) {
      var instance = this.instances[0];

      if (now >= instance.nextUpdateTime) {
        updateInstance(instance, this.instances);
      } else {
        break;
      }
    }
  },
  scheduleNextTick: function scheduleNextTick() {
    var _this2 = this;

    this.scheduledTick = requestAnimationFrame(function () {
      _this2.tick();

      _this2.scheduleNextTick();
    });
  },
  start: function start() {
    this.scheduleNextTick();
  },
  stop: function stop() {
    requestAnimationFrame.cancel(this.scheduledTick);
  }
};

function _updateInstance(instance) {
  var _instance$getNextValu = instance.getNextValue(),
      _instance$getNextValu2 = _slicedToArray(_instance$getNextValu, 2),
      value = _instance$getNextValu2[0],
      nextUpdateTime = _instance$getNextValu2[1];

  instance.setValue(value);
  instance.nextUpdateTime = nextUpdateTime;
}

function updateInstance(instance, instances) {
  _updateInstance(instance);

  remove(instances, instance);

  _add(instances, instance);
}

function _add(instances, instance) {
  var i = findTargetIndex(instances, instance);
  instances.splice(i, 0, instance);
}

function remove(instances, instance) {
  var i = instances.indexOf(instance);
  instances.splice(i, 1);
}

function findTargetIndex(instances, instance) {
  var nextUpdateTime = instance.nextUpdateTime;
  return binarySearch(instances, function (instance) {
    if (instance.nextUpdateTime === nextUpdateTime) {
      return 0;
    } else if (instance.nextUpdateTime > nextUpdateTime) {
      return 1;
    } else {
      return -1;
    }
  });
}
//# sourceMappingURL=Updater.js.map