var _excluded = ["date", "verboseDate", "tooltip", "children"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React, { useMemo } from 'react';
import PropTypes from 'prop-types';
export default function Time(_ref, ref) {
  var date = _ref.date,
      verboseDate = _ref.verboseDate,
      tooltip = _ref.tooltip,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isoString = useMemo(function () {
    return date.toISOString();
  }, [date]);
  return /*#__PURE__*/React.createElement("time", _extends({
    ref: ref
  }, rest, {
    dateTime: isoString,
    title: tooltip ? verboseDate : undefined
  }), children);
} // https://gitlab.com/catamphetamine/react-time-ago/-/issues/5
//
// Someone used this component with "Material UI"'s `<Tooltip/>` component,
// and that component required `children` be `ref`-able.
// https://github.com/mui-org/material-ui/blob/a9903917f919092f80d84075f39fb51d51f241f2/packages/mui-material/src/Tooltip/Tooltip.js#L494-L496
// 
// That component seems to only be using that `ref-`ability to check whether 
// the `children` element qualifies for `:focus-visible` selector.
// https://github.com/mui-org/material-ui/blob/a9903917f919092f80d84075f39fb51d51f241f2/packages/mui-utils/src/useIsFocusVisible.ts#L105
//

Time = /*#__PURE__*/React.forwardRef(Time);
Time.propTypes = {
  date: PropTypes.instanceOf(Date).isRequired,
  verboseDate: PropTypes.string,
  tooltip: PropTypes.bool.isRequired,
  children: PropTypes.string.isRequired
};
//# sourceMappingURL=Time.js.map