"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = useTimeAgo;

var _react = require("react");

var _javascriptTimeAgo = _interopRequireDefault(require("javascript-time-ago"));

var _getVerboseDateFormatter = _interopRequireDefault(require("./helpers/getVerboseDateFormatter.js"));

var _date = require("./helpers/date.js");

var _getTimeAgo = _interopRequireDefault(require("./helpers/getTimeAgo.js"));

var _Updater = _interopRequireDefault(require("./Updater.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function useTimeAgo(_ref) {
  var date = _ref.date,
      future = _ref.future,
      locale = _ref.locale,
      locales = _ref.locales,
      timeStyle = _ref.timeStyle,
      round = _ref.round,
      minTimeLeft = _ref.minTimeLeft,
      formatVerboseDate = _ref.formatVerboseDate,
      _ref$verboseDateForma = _ref.verboseDateFormat,
      verboseDateFormat = _ref$verboseDateForma === void 0 ? DEFAULT_VERBOSE_DATE_FORMAT : _ref$verboseDateForma,
      updateInterval = _ref.updateInterval,
      _ref$tick = _ref.tick,
      tick = _ref$tick === void 0 ? true : _ref$tick,
      nowProperty = _ref.now,
      _ref$timeOffset = _ref.timeOffset,
      timeOffset = _ref$timeOffset === void 0 ? 0 : _ref$timeOffset,
      polyfill = _ref.polyfill;
  // Get the list of preferred locales.
  var preferredLocales = (0, _react.useMemo)(function () {
    // Convert `locale` to `locales`.
    if (locale) {
      locales = [locale];
    } // Add `javascript-time-ago` default locale.


    return locales.concat(_javascriptTimeAgo["default"].getDefaultLocale());
  }, [locale, locales]); // Create `javascript-time-ago` formatter instance.

  var timeAgo = (0, _react.useMemo)(function () {
    return (0, _getTimeAgo["default"])(preferredLocales, {
      polyfill: polyfill
    });
  }, [preferredLocales, polyfill]); // The date or timestamp that was passed.
  // Convert timestamp to `Date`.

  date = (0, _react.useMemo)(function () {
    return (0, _date.getDate)(date);
  }, [date]); // Formats the `date`.

  var formatDate = (0, _react.useCallback)(function () {
    var now = (nowProperty || Date.now()) - timeOffset;
    var stopUpdates;

    if (future) {
      if (now >= date.getTime()) {
        now = date.getTime();
        stopUpdates = true;
      }
    }

    if (minTimeLeft !== undefined) {
      var maxNow = date.getTime() - minTimeLeft * 1000;

      if (now > maxNow) {
        now = maxNow;
        stopUpdates = true;
      }
    }

    var _timeAgo$format = timeAgo.format(date, timeStyle, {
      getTimeToNextUpdate: true,
      now: now,
      future: future,
      round: round
    }),
        _timeAgo$format2 = _slicedToArray(_timeAgo$format, 2),
        formattedDate = _timeAgo$format2[0],
        timeToNextUpdate = _timeAgo$format2[1];

    if (stopUpdates) {
      timeToNextUpdate = INFINITY;
    } else {
      // Legacy compatibility: there used to be an `updateInterval` property.
      // That was before `getTimeToNextUpdate` feature was introduced in `javascript-time-ago`.
      // A default interval of one minute is introduced because
      // `getTimeToNextUpdate` feature may theoretically return `undefined`.
      timeToNextUpdate = updateInterval || timeToNextUpdate || 60 * 1000; // A minute by default.
    }

    return [formattedDate, now + timeToNextUpdate];
  }, [date, future, timeStyle, updateInterval, round, minTimeLeft, timeAgo, nowProperty]);
  var formatDateRef = (0, _react.useRef)();
  formatDateRef.current = formatDate;

  var _useMemo = (0, _react.useMemo)(formatDate, []),
      _useMemo2 = _slicedToArray(_useMemo, 2),
      _formattedDate = _useMemo2[0],
      _nextUpdateTime = _useMemo2[1];

  var _useState = (0, _react.useState)(_formattedDate),
      _useState2 = _slicedToArray(_useState, 2),
      formattedDate = _useState2[0],
      setFormattedDate = _useState2[1];

  var updater = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    if (tick) {
      updater.current = _Updater["default"].add({
        getNextValue: function getNextValue() {
          return formatDateRef.current();
        },
        setValue: setFormattedDate,
        nextUpdateTime: _nextUpdateTime
      });
      return function () {
        return updater.current.stop();
      };
    }
  }, [tick]);
  (0, _react.useEffect)(function () {
    if (updater.current) {
      updater.current.forceUpdate();
    } else {
      var _formatDate = formatDate(),
          _formatDate2 = _slicedToArray(_formatDate, 1),
          _formattedDate2 = _formatDate2[0];

      setFormattedDate(_formattedDate2);
    }
  }, [formatDate]); // Create verbose date formatter for the tooltip text.

  var verboseDateFormatter = (0, _react.useMemo)(function () {
    return (0, _getVerboseDateFormatter["default"])(preferredLocales, verboseDateFormat);
  }, [preferredLocales, verboseDateFormat]); // Format verbose date for the tooltip.

  var verboseDate = (0, _react.useMemo)(function () {
    if (formatVerboseDate) {
      return formatVerboseDate(date);
    }

    return verboseDateFormatter(date);
  }, [date, formatVerboseDate, verboseDateFormatter]);
  return {
    date: date,
    formattedDate: formattedDate,
    verboseDate: verboseDate
  };
} // A thousand years is practically a metaphor for "infinity"
// in the context of this component.


var YEAR = 365 * 24 * 60 * 60 * 1000;
var INFINITY = 1000 * YEAR; // `Intl.DateTimeFormat` for verbose date.
// Formatted date example: "Thursday, December 20, 2012, 7:00:00 AM GMT+4"

var DEFAULT_VERBOSE_DATE_FORMAT = {
  weekday: 'long',
  day: 'numeric',
  month: 'long',
  year: 'numeric',
  hour: 'numeric',
  minute: '2-digit',
  second: '2-digit' // timeZoneName: 'short'

};
//# sourceMappingURL=useTimeAgo.js.map