"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getTimeAgo;

var _javascriptTimeAgo = _interopRequireDefault(require("javascript-time-ago"));

var _cache = _interopRequireDefault(require("./cache.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var TimeAgoCache = new _cache["default"]();

function getTimeAgo(preferredLocales, _ref) {
  var polyfill = _ref.polyfill;
  // `TimeAgo` instance creation is (hypothetically) assumed
  // a lengthy operation so the instances are cached and reused.
  // https://gitlab.com/catamphetamine/react-time-ago/-/issues/1
  var key = String(preferredLocales) + ':' + String(polyfill);
  return TimeAgoCache.get(key) || TimeAgoCache.put(key, new _javascriptTimeAgo["default"](preferredLocales, {
    polyfill: polyfill
  }));
}
//# sourceMappingURL=getTimeAgo.js.map