"use strict";

var _date = require("./date.js");

describe('helpers/date', function () {
  it('should convert Date/number to Date', function () {
    var today = new Date();
    expect((0, _date.getDate)(today.getTime()).getTime()).to.equal(today.getTime());
    expect((0, _date.getDate)(today).getTime()).to.equal(today.getTime());
  });
  it('should support mocked Dates when testing', function () {
    var mockedDate = {
      getTime: function getTime() {
        return Date.now();
      }
    };
    expect((0, _date.getDate)(mockedDate)).to.equal(mockedDate);
  });
});
//# sourceMappingURL=date.test.js.map