"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = Time;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _excluded = ["date", "verboseDate", "tooltip", "children"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function Time(_ref, ref) {
  var date = _ref.date,
      verboseDate = _ref.verboseDate,
      tooltip = _ref.tooltip,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isoString = (0, _react.useMemo)(function () {
    return date.toISOString();
  }, [date]);
  return /*#__PURE__*/_react["default"].createElement("time", _extends({
    ref: ref
  }, rest, {
    dateTime: isoString,
    title: tooltip ? verboseDate : undefined
  }), children);
} // https://gitlab.com/catamphetamine/react-time-ago/-/issues/5
//
// Someone used this component with "Material UI"'s `<Tooltip/>` component,
// and that component required `children` be `ref`-able.
// https://github.com/mui-org/material-ui/blob/a9903917f919092f80d84075f39fb51d51f241f2/packages/mui-material/src/Tooltip/Tooltip.js#L494-L496
// 
// That component seems to only be using that `ref-`ability to check whether 
// the `children` element qualifies for `:focus-visible` selector.
// https://github.com/mui-org/material-ui/blob/a9903917f919092f80d84075f39fb51d51f241f2/packages/mui-utils/src/useIsFocusVisible.ts#L105
//


exports["default"] = Time = /*#__PURE__*/_react["default"].forwardRef(Time);
Time.propTypes = {
  date: _propTypes["default"].instanceOf(Date).isRequired,
  verboseDate: _propTypes["default"].string,
  tooltip: _propTypes["default"].bool.isRequired,
  children: _propTypes["default"].string.isRequired
};
//# sourceMappingURL=Time.js.map