"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Time = _interopRequireDefault(require("./Time.js"));

var _useTimeAgo2 = _interopRequireDefault(require("./useTimeAgo.js"));

var _PropTypes = require("./PropTypes.js");

var _excluded = ["date", "future", "timeStyle", "round", "minTimeLeft", "locale", "locales", "formatVerboseDate", "verboseDateFormat", "updateInterval", "tick", "now", "timeOffset", "polyfill", "tooltip", "component", "container", "wrapperComponent", "wrapperProps"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ReactTimeAgo(_ref) {
  var dateProperty = _ref.date,
      future = _ref.future,
      timeStyle = _ref.timeStyle,
      round = _ref.round,
      minTimeLeft = _ref.minTimeLeft,
      locale = _ref.locale,
      _ref$locales = _ref.locales,
      locales = _ref$locales === void 0 ? [] : _ref$locales,
      formatVerboseDate = _ref.formatVerboseDate,
      verboseDateFormat = _ref.verboseDateFormat,
      updateInterval = _ref.updateInterval,
      tick = _ref.tick,
      nowProperty = _ref.now,
      timeOffset = _ref.timeOffset,
      polyfill = _ref.polyfill,
      _ref$tooltip = _ref.tooltip,
      tooltip = _ref$tooltip === void 0 ? true : _ref$tooltip,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? _Time["default"] : _ref$component,
      container = _ref.container,
      wrapperComponent = _ref.wrapperComponent,
      wrapperProps = _ref.wrapperProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useTimeAgo = (0, _useTimeAgo2["default"])({
    date: dateProperty,
    future: future,
    timeStyle: timeStyle,
    round: round,
    minTimeLeft: minTimeLeft,
    locale: locale,
    locales: locales,
    formatVerboseDate: formatVerboseDate,
    verboseDateFormat: verboseDateFormat,
    updateInterval: updateInterval,
    tick: tick,
    now: nowProperty,
    timeOffset: timeOffset,
    polyfill: polyfill
  }),
      date = _useTimeAgo.date,
      verboseDate = _useTimeAgo.verboseDate,
      formattedDate = _useTimeAgo.formattedDate;

  var result = /*#__PURE__*/_react["default"].createElement(Component, _extends({
    date: date,
    verboseDate: verboseDate,
    tooltip: tooltip
  }, rest), formattedDate);

  var WrapperComponent = wrapperComponent || container;

  if (WrapperComponent) {
    return /*#__PURE__*/_react["default"].createElement(WrapperComponent, _extends({}, wrapperProps, {
      verboseDate: verboseDate
    }), result);
  }

  return result;
}

ReactTimeAgo.propTypes = {
  // `date: Date` or `timestamp: number`.
  // E.g. `new Date()` or `1355972400000`.
  date: _propTypes["default"].oneOfType([_propTypes["default"].instanceOf(Date), _propTypes["default"].number]).isRequired,
  // Preferred locale.
  // Is 'en' by default.
  // E.g. 'ru-RU'.
  locale: _propTypes["default"].string,
  // Alternatively to `locale`, one could pass `locales`:
  // A list of preferred locales (ordered).
  // Will choose the first supported locale from the list.
  // E.g. `['ru-RU', 'en-GB']`.
  locales: _propTypes["default"].arrayOf(_propTypes["default"].string),
  // If set to `true`, then will stop at "zero point"
  // when going from future dates to past dates.
  // In other words, even if the `date` has passed,
  // it will still render as if `date` is `now`.
  future: _propTypes["default"].bool,
  // Date/time formatting style.
  // See `javascript-time-ago` docs on "Styles" for more info.
  // E.g. 'round', 'round-minute', 'twitter', 'twitter-first-minute'.
  timeStyle: _PropTypes.style,
  // `round` parameter of `javascript-time-ago`.
  // See `javascript-time-ago` docs on "Rounding" for more info.
  // Examples: "round", "floor".
  round: _propTypes["default"].string,
  // If specified, the time won't "tick" past this threshold (in seconds).
  // For example, if `minTimeLeft` is `60 * 60`
  // then the time won't "tick" past "in 1 hour".
  minTimeLeft: _propTypes["default"].number,
  // A React component to render the relative time label.
  // Receives properties:
  // * date: Date — The date.
  // * verboseDate: string — Formatted verbose date.
  // * tooltip: boolean — The `tooltip` property of `<ReactTimeAgo/>` component.
  // * children: string — The relative time label.
  // * All "unknown" properties that have been passed to `<ReactTimeAgo/>` are passed through to this component.
  component: _propTypes["default"].elementType,
  // Whether to use HTML `tooltip` attribute to show a verbose date tooltip.
  // Is `true` by default.
  // Can be set to `false` to disable the native HTML `tooltip`.
  tooltip: _propTypes["default"].bool,
  // Verbose date formatter.
  // By default it's `(date) => new Intl.DateTimeFormat(locale, {…}).format(date)`.
  formatVerboseDate: _propTypes["default"].func,
  // `Intl.DateTimeFormat` format for formatting verbose date.
  // See `Intl.DateTimeFormat` docs for more info.
  verboseDateFormat: _propTypes["default"].object,
  // (deprecated)
  // How often the component refreshes itself.
  // When not provided, will use `getNextTimeToUpdate()` feature
  // of `javascript-time-ago` styles to determine the update interval.
  updateInterval: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].arrayOf(_propTypes["default"].shape({
    threshold: _propTypes["default"].number,
    interval: _propTypes["default"].number.isRequired
  }))]),
  // (deprecated).
  // Set to `false` to disable automatic refresh of the component.
  // Is `true` by default.
  // I guess no one actually turns auto-update off, so this parameter is deprecated.
  tick: _propTypes["default"].bool,
  // Allows setting a custom baseline for relative time measurement.
  // https://gitlab.com/catamphetamine/react-time-ago/-/issues/4
  now: _propTypes["default"].number,
  // Allows offsetting the `date` by an arbitrary amount of milliseconds.
  // https://gitlab.com/catamphetamine/react-time-ago/-/issues/4
  timeOffset: _propTypes["default"].number,
  // Pass `false` to use native `Intl.RelativeTimeFormat` / `Intl.PluralRules`
  // instead of the polyfilled ones in `javascript-time-ago`.
  polyfill: _propTypes["default"].bool,
  // (advanced)
  // A React Component to wrap the resulting `<time/>` React Element.
  // Receives `verboseDate` and `children` properties.
  // Also receives `wrapperProps`, if they're passed.
  // `verboseDate` can be used for displaying verbose date label
  // in an "on mouse over" (or "on touch") tooltip.
  // See the "Tooltip" readme section for more info.
  // Another example could be having `wrapperComponent`
  // being rerendered every time the component refreshes itself.
  wrapperComponent: _propTypes["default"].elementType,
  // Custom `props` passed to `wrapperComponent`.
  wrapperProps: _propTypes["default"].object
}; // The component schedules a next refresh every time it renders.
// There's no need to rerender this component unless its props change.

ReactTimeAgo = /*#__PURE__*/_react["default"].memo(ReactTimeAgo);
var _default = ReactTimeAgo;
exports["default"] = _default;
//# sourceMappingURL=ReactTimeAgo.js.map