# next-tawkto

A simple wrapper around tawk.to JS API to help integrate chat into any application that is based on the react framework.

Forked from [Steve-Junior/tawkto-react](https://github.com/Steve-Junior/tawkto-react) and added support for React v18 since it was stopping me from upgrading to Next.js v13

## Installation

```sh
npm install next-tawkto --save
```

## Usage

This package is simple react wrapper around the tawk.to JS API. Explore the [Tawk JS API](https://developer.tawk.to/jsapi/) as you wish.

Please consider migrating to the latest version and fetch the `propertyId` and  `tawkId` from your account

![Screenshot](demo.png)


## class component

```javascript
import TawkTo from "next-tawkto"

componentDidMount()
{
    var tawk = new TawkTo(propertyId, tawkId)

    tawk.hideWidget()
}
```

## functional component

```javascript
import TawkTo from "next-tawkto"

useEffect(() => {
    
    var tawk = new TawkTo(propertyId, tawkId)

    tawk.onStatusChange((status) => 
    {
        // console.log(status)
    })

}, [])
```

## my preferred implementation in Next.js hosted on Vercel

```javascript
useEffect(() => {
    if (!window) return;

    if (process.env.NEXT_PUBLIC_ENVIRONMENT !== "live") return;

    new tawkTo(propertyId, tawkId);
}, []);
```

## License
[MIT](LICENSE)

## Authors

* **Steve Junior**
* Zahid Mahmood


