function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import twitter from './twitterMinute.js';
import TimeAgo from '../TimeAgo.js';
import { hour, minute, day, month, year } from '../steps/index.js';
describe('style/twitterMinute', function () {
  it('should format Twitter style relative time (English) (round: "floor")', function () {
    var timeAgo = new TimeAgo('en');

    // April 10th, 2016.
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, twitter), {}, {
        round: 'floor'
      }));
    };
    formatInterval(0).should.equal('0m');
    formatInterval(59.9).should.equal('0m');
    formatInterval(60).should.equal('1m');
    formatInterval(1.9 * minute).should.equal('1m');
    formatInterval(2 * minute).should.equal('2m');
    formatInterval(2.9 * minute).should.equal('2m');
    formatInterval(3 * minute).should.equal('3m');
    // …
    formatInterval(59.9 * minute).should.equal('59m');
    formatInterval(60 * minute).should.equal('1h');
    formatInterval(1.9 * hour).should.equal('1h');
    formatInterval(2 * hour).should.equal('2h');
    formatInterval(2.9 * hour).should.equal('2h');
    formatInterval(3 * hour).should.equal('3h');
    // …
    formatInterval(23.9 * hour).should.equal('23h');
    formatInterval(day + 2 * minute + hour).should.equal('Apr 9');
    // …
    // `month` is about 30.5 days.
    formatInterval(month * 3).should.equal('Jan 10');
    formatInterval(month * 4).should.equal('Dec 11, 2015');
    formatInterval(year).should.equal('Apr 11, 2015');

    // Test future dates.
    // `month` is about 30.5 days.
    formatInterval(-1 * month * 8).should.equal('Dec 10');
    formatInterval(-1 * month * 9).should.equal('Jan 9, 2017');
  });
  it('should format Twitter style relative time (English) (round: "round")', function () {
    var timeAgo = new TimeAgo('en');

    // April 10th, 2016.
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, twitter), {}, {
        round: 'round'
      }));
    };
    formatInterval(0).should.equal('0m');
    formatInterval(29.9).should.equal('0m');
    formatInterval(30).should.equal('1m');
    formatInterval(1.49 * minute).should.equal('1m');
    formatInterval(1.5 * minute).should.equal('2m');
    formatInterval(2.49 * minute).should.equal('2m');
    formatInterval(2.5 * minute).should.equal('3m');
  });
});
//# sourceMappingURL=twitterMinute.test.js.map