import renameLegacyProperties from './renameLegacyProperties.js';
describe('steps/renameLegacyProperties', function () {
  it('should rename legacy properties', function () {
    renameLegacyProperties({
      formatAs: 'now',
      minTime: 1
    }).should.deep.equal({
      unit: 'now',
      threshold: 1
    });
  });
  it('should rename legacy properties (minTime: undefined)', function () {
    renameLegacyProperties({
      formatAs: 'now'
    }).should.deep.equal({
      unit: 'now'
    });
  });
  it('should rename legacy properties (`minTime` is an object)', function () {
    renameLegacyProperties({
      formatAs: 'now',
      minTime: {
        week: 2,
        "default": 1
      }
    }).should.deep.equal({
      unit: 'now',
      threshold: 1,
      threshold_for_week: 2
    });
  });
});
//# sourceMappingURL=renameLegacyProperties.test.js.map