"use strict";

var _twitterNow = _interopRequireDefault(require("./twitterNow.js"));
var _TimeAgo = _interopRequireDefault(require("../TimeAgo.js"));
var _index = require("../steps/index.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
describe('style/twitterNow', function () {
  it('should format Twitter style relative time (English) (round: "floor")', function () {
    var timeAgo = new _TimeAgo["default"]('en');

    // April 10th, 2016.
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, _twitterNow["default"]), {}, {
        round: 'floor'
      }));
    };
    formatInterval(0).should.equal('now');
    formatInterval(0.9).should.equal('now');
    formatInterval(1).should.equal('1s');
    formatInterval(59.9).should.equal('59s');
    formatInterval(60).should.equal('1m');
    formatInterval(1.9 * _index.minute).should.equal('1m');
    formatInterval(2 * _index.minute).should.equal('2m');
    formatInterval(2.9 * _index.minute).should.equal('2m');
    formatInterval(3 * _index.minute).should.equal('3m');
    // …
    formatInterval(59.9 * _index.minute).should.equal('59m');
    formatInterval(60 * _index.minute).should.equal('1h');
    formatInterval(1.9 * _index.hour).should.equal('1h');
    formatInterval(2 * _index.hour).should.equal('2h');
    formatInterval(2.9 * _index.hour).should.equal('2h');
    formatInterval(3 * _index.hour).should.equal('3h');
    // …
    formatInterval(23.9 * _index.hour).should.equal('23h');
    formatInterval(_index.day + 2 * _index.minute + _index.hour).should.equal('Apr 9');
    // …
    // `month` is about 30.5 days.
    formatInterval(_index.month * 3).should.equal('Jan 10');
    formatInterval(_index.month * 4).should.equal('Dec 11, 2015');
    formatInterval(_index.year).should.equal('Apr 11, 2015');

    // Test future dates.
    // `month` is about 30.5 days.
    formatInterval(-1 * _index.month * 8).should.equal('Dec 10');
    formatInterval(-1 * _index.month * 9).should.equal('Jan 9, 2017');
  });
  it('should format Twitter style relative time (Russian) (round: "floor")', function () {
    var timeAgo = new _TimeAgo["default"]('ru');
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, _twitterNow["default"]), {}, {
        round: 'floor'
      }));
    };
    formatInterval(0).should.equal('сейчас');
    formatInterval(0.9).should.equal('сейчас');
    formatInterval(1).should.equal('1 с');
    formatInterval(60).should.equal('1 мин');
    formatInterval(60 * _index.minute).should.equal('1 ч');
    formatInterval(_index.day + 62 * _index.minute).should.equal('9 апр.');
    formatInterval(_index.year).should.equal('11 апр. 2015 г.');
  });
});
//# sourceMappingURL=twitterNow.test.js.map