"use strict";

var _round = _interopRequireDefault(require("./round.js"));
var _TimeAgo = _interopRequireDefault(require("../TimeAgo.js"));
var _index = require("../steps/index.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
describe('style/round', function () {
  it('should format relative time (English) (round: "floor")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, _round["default"]), {}, {
        round: 'floor'
      }));
    };
    formatInterval(0).should.equal('just now');
    formatInterval(0.9).should.equal('just now');
    formatInterval(1).should.equal('1 second ago');
    formatInterval(59.9).should.equal('59 seconds ago');
    formatInterval(60).should.equal('1 minute ago');
    formatInterval(1.9 * 60).should.equal('1 minute ago');
    formatInterval(2 * 60).should.equal('2 minutes ago');
    formatInterval(2.9 * 60).should.equal('2 minutes ago');
    formatInterval(3 * 60).should.equal('3 minutes ago');
    // …
    formatInterval(59.9 * 60).should.equal('59 minutes ago');
    formatInterval(60 * 60).should.equal('1 hour ago');
    formatInterval(1.9 * 60 * 60).should.equal('1 hour ago');
    formatInterval(2 * 60 * 60).should.equal('2 hours ago');
    formatInterval(2.9 * 60 * 60).should.equal('2 hours ago');
    formatInterval(3 * 60 * 60).should.equal('3 hours ago');
    // …
    formatInterval(23.9 * 60 * 60).should.equal('23 hours ago');
    formatInterval(24 * 60 * 60).should.equal('1 day ago');
    formatInterval(1.9 * _index.day).should.equal('1 day ago');
    formatInterval(2 * _index.day).should.equal('2 days ago');
    formatInterval(2.9 * _index.day).should.equal('2 days ago');
    formatInterval(3 * _index.day).should.equal('3 days ago');
    // …
    formatInterval(6.9 * _index.day).should.equal('6 days ago');
    formatInterval(7 * _index.day).should.equal('1 week ago');
    // …
    formatInterval(3.9 * 7 * _index.day).should.equal('3 weeks ago');
    formatInterval(4 * 7 * _index.day).should.equal('4 weeks ago');
    formatInterval(30.51 * _index.day).should.equal('1 month ago');
    formatInterval(1.9 * _index.month).should.equal('1 month ago');
    formatInterval(2 * _index.month).should.equal('2 months ago');
    formatInterval(2.9 * _index.month).should.equal('2 months ago');
    formatInterval(3 * _index.month).should.equal('3 months ago');
    // …
    formatInterval(11.9 * _index.month).should.equal('11 months ago');
    formatInterval(12 * _index.month).should.equal('1 year ago');
    formatInterval(1.99 * _index.year).should.equal('1 year ago');
    formatInterval(2 * _index.year).should.equal('2 years ago');
    // …

    // Test future dates.
    formatInterval(-1 * 3).should.equal('in 3 seconds');
    formatInterval(-1 * _index.month * 8).should.equal('in 8 months');
  });
  it('should format relative time (English) (round: "round")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var now = new Date(2016, 3, 10, 22, 59).getTime();
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(now - secondsPassed * 1000, _objectSpread(_objectSpread({
        now: now
      }, _round["default"]), {}, {
        round: 'round'
      }));
    };
    formatInterval(0).should.equal('just now');
    formatInterval(0.49).should.equal('just now');
    formatInterval(0.5).should.equal('1 second ago');
    formatInterval(59.49).should.equal('59 seconds ago');
    formatInterval(59.5).should.equal('1 minute ago');
    formatInterval(1.49 * 60).should.equal('1 minute ago');
    formatInterval(1.5 * 60).should.equal('2 minutes ago');
    formatInterval(2.49 * 60).should.equal('2 minutes ago');
    formatInterval(2.5 * 60).should.equal('3 minutes ago');
    // …
    formatInterval(59.49 * 60).should.equal('59 minutes ago');
    formatInterval(59.5 * 60).should.equal('1 hour ago');
    formatInterval(1.49 * 60 * 60).should.equal('1 hour ago');
    formatInterval(1.5 * 60 * 60).should.equal('2 hours ago');
    formatInterval(2.49 * 60 * 60).should.equal('2 hours ago');
    formatInterval(2.5 * 60 * 60).should.equal('3 hours ago');
    // …
    formatInterval(23.49 * 60 * 60).should.equal('23 hours ago');
    formatInterval(23.5 * 60 * 60).should.equal('1 day ago');
    formatInterval(1.49 * _index.day).should.equal('1 day ago');
    formatInterval(1.5 * _index.day).should.equal('2 days ago');
    formatInterval(2.49 * _index.day).should.equal('2 days ago');
    formatInterval(2.5 * _index.day).should.equal('3 days ago');
    // …
    formatInterval(6.49 * _index.day).should.equal('6 days ago');
    formatInterval(6.5 * _index.day).should.equal('1 week ago');
    // …
    formatInterval(3.49 * 7 * _index.day).should.equal('3 weeks ago');
    formatInterval(3.5 * 7 * _index.day).should.equal('4 weeks ago');
    formatInterval(30.51 * _index.day).should.equal('1 month ago');
    formatInterval(1.49 * _index.month).should.equal('1 month ago');
    formatInterval(1.5 * _index.month).should.equal('2 months ago');
    formatInterval(2.49 * _index.month).should.equal('2 months ago');
    formatInterval(2.5 * _index.month).should.equal('3 months ago');
    // …
    formatInterval(11.49 * _index.month).should.equal('11 months ago');
    formatInterval(11.5 * _index.month).should.equal('1 year ago');
    formatInterval(1.49 * _index.year).should.equal('1 year ago');
    formatInterval(1.5 * _index.year).should.equal('2 years ago');
    // …

    // Test future dates.
    formatInterval(-1 * 3).should.equal('in 3 seconds');
    formatInterval(-1 * _index.month * 8).should.equal('in 8 months');
  });
  it('should return correct update interval (round: "floor")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var _timeAgo$format = timeAgo.format(0, _round["default"], {
        now: 0,
        getTimeToNextUpdate: true,
        round: 'floor'
      }),
      _timeAgo$format2 = _slicedToArray(_timeAgo$format, 2),
      formattedDate = _timeAgo$format2[0],
      timeToNextUpdate = _timeAgo$format2[1];
    timeToNextUpdate.should.equal(1000);
  });
  it('should return correct update interval (round: "round")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var _timeAgo$format3 = timeAgo.format(0, _round["default"], {
        now: 0,
        getTimeToNextUpdate: true
      }),
      _timeAgo$format4 = _slicedToArray(_timeAgo$format3, 2),
      formattedDate = _timeAgo$format4[0],
      timeToNextUpdate = _timeAgo$format4[1];
    timeToNextUpdate.should.equal(500);
  });
});
//# sourceMappingURL=round.test.js.map