"use strict";

var _renameLegacyProperties = _interopRequireDefault(require("./renameLegacyProperties.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
describe('style/renameLegacyProperties', function () {
  it('should rename legacy properties', function () {
    (0, _renameLegacyProperties["default"])({
      steps: [{
        unit: 'now',
        minTime: {
          week: 2,
          "default": 1
        }
      }],
      labels: 'long'
    }).should.deep.equal({
      gradation: [{
        unit: 'now',
        threshold: 1,
        threshold_for_week: 2
      }],
      flavour: 'long'
    });
  });
  it('should cover edge cases', function () {
    var custom = function custom() {};
    (0, _renameLegacyProperties["default"])({
      custom: custom
    }).should.deep.equal({
      custom: custom
    });
  });
});
//# sourceMappingURL=renameLegacyProperties.test.js.map