"use strict";

var _mini = _interopRequireDefault(require("./mini.js"));
var _TimeAgo = _interopRequireDefault(require("../TimeAgo.js"));
var _index = require("../steps/index.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
describe('style/mini', function () {
  it('should format relative date/time (round: "floor")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(-secondsPassed * 1000, _objectSpread(_objectSpread({
        now: 0
      }, _mini["default"]), {}, {
        round: 'floor'
      }));
    };
    formatInterval(0).should.equal('0s');
    formatInterval(0.9).should.equal('0s');
    formatInterval(1).should.equal('1s');
    formatInterval(59.9).should.equal('59s');
    formatInterval(60).should.equal('1m');
    formatInterval(1.9 * _index.minute).should.equal('1m');
    formatInterval(2 * _index.minute).should.equal('2m');
    formatInterval(2.9 * _index.minute).should.equal('2m');
    formatInterval(3 * _index.minute).should.equal('3m');
    // …
    formatInterval(59.9 * _index.minute).should.equal('59m');
    formatInterval(60 * _index.minute).should.equal('1h');
    formatInterval(1.9 * _index.hour).should.equal('1h');
    formatInterval(2 * _index.hour).should.equal('2h');
    formatInterval(2.9 * _index.hour).should.equal('2h');
    formatInterval(3 * _index.hour).should.equal('3h');
    // …
    formatInterval(23.9 * _index.hour).should.equal('23h');
    formatInterval(24 * _index.hour).should.equal('1d');
    formatInterval(2 * _index.day).should.equal('2d');
    formatInterval(7 * _index.day).should.equal('7d');
    formatInterval(30 * _index.day).should.equal('30d');
    formatInterval(_index.month).should.equal('1mo');
    formatInterval(360 * _index.day).should.equal('11mo');
    formatInterval(366 * _index.day).should.equal('1yr');
  });
  it('should format relative date/time (round: "round")', function () {
    var timeAgo = new _TimeAgo["default"]('en');
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(-secondsPassed * 1000, _objectSpread({
        now: 0
      }, _mini["default"]));
    };
    formatInterval(0).should.equal('0s');
    formatInterval(0.49).should.equal('0s');
    formatInterval(0.5).should.equal('1s');
    formatInterval(59.49).should.equal('59s');
    formatInterval(59.5).should.equal('1m');
    formatInterval(1.49 * _index.minute).should.equal('1m');
    formatInterval(1.5 * _index.minute).should.equal('2m');
    formatInterval(2.49 * _index.minute).should.equal('2m');
    formatInterval(2.5 * _index.minute).should.equal('3m');
    // …
    formatInterval(59.49 * _index.minute).should.equal('59m');
    formatInterval(59.5 * _index.minute).should.equal('1h');
    formatInterval(1.49 * _index.hour).should.equal('1h');
    formatInterval(1.5 * _index.hour).should.equal('2h');
    formatInterval(2.49 * _index.hour).should.equal('2h');
    formatInterval(2.5 * _index.hour).should.equal('3h');
    // …
    formatInterval(23.49 * _index.hour).should.equal('23h');
    formatInterval(23.5 * _index.hour).should.equal('1d');
    formatInterval(2 * _index.day).should.equal('2d');
    formatInterval(7 * _index.day).should.equal('7d');
    formatInterval(29 * _index.day).should.equal('29d');
    formatInterval(30 * _index.day).should.equal('1mo');
    formatInterval(_index.month).should.equal('1mo');
    formatInterval(350 * _index.day).should.equal('11mo');
    formatInterval(360 * _index.day).should.equal('1yr');
    formatInterval(366 * _index.day).should.equal('1yr');
  });
  it('should format relative date/time (Russian)', function () {
    var timeAgo = new _TimeAgo["default"]('ru');
    var formatInterval = function formatInterval(secondsPassed) {
      return timeAgo.format(-secondsPassed * 1000, _objectSpread({
        now: 0
      }, _mini["default"]));
    };
    formatInterval(0).should.equal('0 с');
    formatInterval(1).should.equal('1 с');
    formatInterval(_index.minute).should.equal('1 мин');
    formatInterval(_index.hour).should.equal('1 ч');
    formatInterval(_index.day).should.equal('1 д');
    formatInterval(_index.month).should.equal('1 мес');
    formatInterval(_index.year).should.equal('1 г');
    formatInterval(5 * _index.year).should.equal('5 л');
  });
});
//# sourceMappingURL=mini.test.js.map