"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.day = void 0;
exports.getSecondsInUnit = getSecondsInUnit;
exports.year = exports.week = exports.month = exports.minute = exports.hour = void 0;
var minute = exports.minute = 60; // in seconds

var hour = exports.hour = 60 * minute; // in seconds

var day = exports.day = 24 * hour; // in seconds

var week = exports.week = 7 * day; // in seconds

// https://www.quora.com/What-is-the-average-number-of-days-in-a-month
var month = exports.month = 30.44 * day; // in seconds

// "400 years have 146097 days (taking into account leap year rules)"
var year = exports.year = 146097 / 400 * day; // in seconds

function getSecondsInUnit(unit) {
  switch (unit) {
    case 'second':
      return 1;
    case 'minute':
      return minute;
    case 'hour':
      return hour;
    case 'day':
      return day;
    case 'week':
      return week;
    case 'month':
      return month;
    case 'year':
      return year;
  }
}

// export function getPreviousUnitFor(unit) {
// 	switch (unit) {
// 		case 'second':
// 			return 'now'
// 		case 'minute':
// 			return 'second'
// 		case 'hour':
// 			return 'minute'
// 		case 'day':
// 			return 'hour'
// 		case 'week':
// 			return 'day'
// 		case 'month':
// 			return 'week'
// 		case 'year':
// 			return 'month'
// 	}
// }
//# sourceMappingURL=units.js.map