"use strict";

var _renameLegacyProperties = _interopRequireDefault(require("./renameLegacyProperties.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
describe('steps/renameLegacyProperties', function () {
  it('should rename legacy properties', function () {
    (0, _renameLegacyProperties["default"])({
      formatAs: 'now',
      minTime: 1
    }).should.deep.equal({
      unit: 'now',
      threshold: 1
    });
  });
  it('should rename legacy properties (minTime: undefined)', function () {
    (0, _renameLegacyProperties["default"])({
      formatAs: 'now'
    }).should.deep.equal({
      unit: 'now'
    });
  });
  it('should rename legacy properties (`minTime` is an object)', function () {
    (0, _renameLegacyProperties["default"])({
      formatAs: 'now',
      minTime: {
        week: 2,
        "default": 1
      }
    }).should.deep.equal({
      unit: 'now',
      threshold: 1,
      threshold_for_week: 2
    });
  });
});
//# sourceMappingURL=renameLegacyProperties.test.js.map