"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _getTimeToNextUpdate = _interopRequireWildcard(require("./getTimeToNextUpdate.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, "default": e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
describe('getTimeToNextUpdate', function () {
  it('should return infinity when there are no more steps, and it does not format as a unit (past)', function () {
    expect((0, _getTimeToNextUpdate["default"])(-4 * 60 * 1000, {
      minTime: 59.5,
      format: function format() {
        return '';
      }
    }, {
      now: 0,
      future: false,
      isFirstStep: true
    })).to.equal(_getTimeToNextUpdate.INFINITY);
  });
  it('should support date argument', function () {
    expect((0, _getTimeToNextUpdate["default"])(new Date(4 * 60 * 1000), {
      minTime: 60
    }, {
      now: 0,
      future: true,
      isFirstStep: true,
      nextStep: {}
    })).to.equal(3 * 60 * 1000 + 1);
  });
  it('should return this step\'s "minTime" timestamp (future)', function () {
    expect((0, _getTimeToNextUpdate["default"])(4 * 60 * 1000, {
      minTime: 60,
      format: function format() {
        return '';
      }
    }, {
      now: 0,
      future: true,
      isFirstStep: true,
      nextStep: {
        format: function format() {
          return '';
        }
      }
    })).to.equal(3 * 60 * 1000 + 1);
  });
  it('should return undefined when there is a next step and time to next update can not be reliably determined (formatAs) (past)', function () {
    expect((0, _getTimeToNextUpdate["default"])(-4 * 60 * 1000, {
      minTime: 60,
      formatAs: 'minute'
    }, {
      now: 0,
      future: false,
      isFirstStep: true,
      nextStep: {
        formatAs: 'unknown-time-unit'
      }
    })).to.be.undefined;
  });
  it('should get time to next update (no next step) (past)', function () {
    (0, _getTimeToNextUpdate["default"])(-4 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5
    }, {
      now: 0,
      future: false,
      isFirstStep: true
    }).should.equal(0.5 * 60 * 1000);
  });
  it('should get time to next update (no next step) (future)', function () {
    (0, _getTimeToNextUpdate["default"])(4 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5
    }, {
      now: 0,
      future: true,
      isFirstStep: true
    }).should.equal(0.5 * 60 * 1000 + 1);
  });
  it('should get time to next update (has prev/next step without `minTime`) (future)', function () {
    (0, _getTimeToNextUpdate["default"])(4 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5
    }, {
      now: 0,
      future: true,
      isFirstStep: true,
      nextStep: {
        formatAs: 'hour',
        test: function test() {
          return false;
        }
      }
    }).should.equal(0.5 * 60 * 1000 + 1);
  });
  it('should get time to next update (has `getTimeToNextUpdate`) (past)', function () {
    (0, _getTimeToNextUpdate["default"])(-4 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5,
      getTimeToNextUpdate: function getTimeToNextUpdate() {
        return 0.25 * 60 * 1000;
      }
    }, {
      now: 0,
      future: false,
      isFirstStep: true
    }).should.equal(0.25 * 60 * 1000);
  });
  it('should get time to next update (has `getTimeToNextUpdate`) (future)', function () {
    (0, _getTimeToNextUpdate["default"])(4 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5,
      getTimeToNextUpdate: function getTimeToNextUpdate() {
        return 0.25 * 60 * 1000;
      }
    }, {
      now: 0,
      future: true,
      isFirstStep: true
    }).should.equal(0.25 * 60 * 1000);
  });
  it('should get time to next update (has both unit and prev/next steps with `minTime`) (returns time to "minTime" of next step) (past)', function () {
    (0, _getTimeToNextUpdate["default"])(-59 * 60 * 1000, {
      formatAs: 'minute',
      minTime: 59.5
    }, {
      now: 0,
      future: false,
      isFirstStep: true,
      nextStep: {
        formatAs: 'hour',
        minTime: 59.5 * 60
      }
    }).should.equal(0.5 * 60 * 1000);
  });
  it('should get time to next update (has no unit but has prev/next step with `minTime`) (returns time to "minTime" of next step) (past)', function () {
    (0, _getTimeToNextUpdate["default"])(-59 * 60 * 1000, {
      format: function format() {},
      minTime: 59.5
    }, {
      now: 0,
      future: false,
      isFirstStep: true,
      nextStep: {
        formatAs: 'hour',
        minTime: 59.5 * 60
      }
    }).should.equal(0.5 * 60 * 1000);
  });
  it('should get time to next update (will be outside of the first step) (future)', function () {
    (0, _getTimeToNextUpdate["default"])(60 * 60 * 1000, {
      formatAs: 'hour',
      minTime: 60 * 60
    }, {
      now: 0,
      future: true,
      isFirstStep: true
    }).should.equal(1);
  });
});
describe('getStepChangesAt', function () {
  it('should work for "round" steps', function () {
    // Future.
    // Is at zero point.
    // No next step.
    // No tickable unit.
    // Doesn't update.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      unit: 'now'
    }, 0, {
      now: 0,
      future: false,
      prevStep: undefined
    }).should.equal(_getTimeToNextUpdate.INFINITY);

    // Past.
    // Is at zero point.
    // The next step is seconds.
    // Updates at the next step.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      unit: 'second',
      minTime: 1
    }, 0, {
      now: 0,
      future: false,
      prevStep: {}
    }).should.equal(1 * 1000);

    // Future.
    // Inside the first step.
    // Updates after zero point.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      unit: 'now'
    }, 0.9 * 1000, {
      now: 0,
      future: true,
      prevStep: undefined
    }).should.equal(0.9 * 1000 + 1);

    // Future.
    // The first step doesn't start at 0.
    // Outside of the first step.
    // Updates right after zero point.
    (0, _getTimeToNextUpdate.getTimeToStepChange)(undefined, 0.9 * 1000, {
      now: 0,
      future: true,
      prevStep: undefined
    }).should.equal(0.9 * 1000 + 1);

    // Past.
    // The current step is `undefined`.
    // The next step is the first step.
    // The first step doesn't start at 0.
    // Outside of the first step.
    // Updates at entering the first step.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      minTime: 1,
      unit: 'second'
    }, -0.9 * 1000, {
      now: 0,
      future: false,
      prevStep: {}
    }).should.equal(0.1 * 1000);

    // Future.
    // The first step doesn't start at 0.
    // Will output empty string after it exits the current step.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      minTime: 1,
      unit: 'second'
    }, 1.1 * 1000, {
      now: 0,
      future: true,
      prevStep: undefined
    }).should.equal(0.1 * 1000 + 1);

    // Past.
    // Next step is seconds.
    // The "next" step doesn't have `minTime`,
    // so "time to next update" couldn't be determined.
    expect((0, _getTimeToNextUpdate.getStepChangesAt)({
      unit: 'unknown-time-unit'
    }, 0, {
      now: 0,
      future: false,
      prevStep: {}
    })).to.be.undefined;

    // Past.
    // No next step.
    // The last step never changes.
    (0, _getTimeToNextUpdate.getTimeToStepChange)(undefined, 0, {
      now: 0,
      future: false,
      isFirstStep: undefined
    }).should.equal(_getTimeToNextUpdate.INFINITY);

    // Future.
    // Current step is seconds.
    // Updates after zero point.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      unit: 'second'
    }, 0, {
      now: 0,
      future: true,
      prevStep: undefined
    }).should.equal(1);

    // Past.
    // Next step is minutes.
    // Already at zero point, so no need to update at zero point.
    (0, _getTimeToNextUpdate.getStepChangesAt)({
      minTime: 60,
      formatAs: 'minute'
    }, 0, {
      now: 0,
      future: false,
      prevStep: {}
    }).should.equal(60 * 1000);
  });
});
//# sourceMappingURL=getTimeToNextUpdate.test.js.map