"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getStepMinTime;
var _units = require("./units.js");
var _round = require("../round.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function getStepMinTime(step, _ref) {
  var prevStep = _ref.prevStep,
    timestamp = _ref.timestamp,
    now = _ref.now,
    future = _ref.future,
    round = _ref.round;
  var minTime;
  // "threshold_for_xxx" is a legacy property.
  if (prevStep) {
    if (prevStep.id || prevStep.unit) {
      minTime = step["threshold_for_".concat(prevStep.id || prevStep.unit)];
    }
  }
  if (minTime === undefined) {
    // "threshold" is a legacy property.
    if (step.threshold !== undefined) {
      // "threshold" is a legacy name for "minTime".
      minTime = step.threshold;
      // "threshold" function is deprecated.
      if (typeof minTime === 'function') {
        minTime = minTime(now, future);
      }
    }
  }
  if (minTime === undefined) {
    minTime = step.minTime;
  }
  // A deprecated way of specifying a different threshold
  // depending on the previous step's unit.
  if (_typeof(minTime) === 'object') {
    if (prevStep && prevStep.id && minTime[prevStep.id] !== undefined) {
      minTime = minTime[prevStep.id];
    } else {
      minTime = minTime["default"];
    }
  }
  if (typeof minTime === 'function') {
    minTime = minTime(timestamp, {
      future: future,
      getMinTimeForUnit: function getMinTimeForUnit(toUnit, fromUnit) {
        return _getMinTimeForUnit(toUnit, fromUnit || prevStep && prevStep.formatAs, {
          round: round
        });
      }
    });
  }
  // Evaluate the `test()` function.
  // `test()` function is deprecated.
  if (minTime === undefined) {
    if (step.test) {
      if (step.test(timestamp, {
        now: now,
        future: future
      })) {
        // `0` threshold always passes.
        minTime = 0;
      } else {
        // `MAX_SAFE_INTEGER` threshold won't ever pass in real life.
        minTime = 9007199254740991; // Number.MAX_SAFE_INTEGER
      }
    }
  }
  if (minTime === undefined) {
    if (prevStep) {
      if (step.formatAs && prevStep.formatAs) {
        minTime = _getMinTimeForUnit(step.formatAs, prevStep.formatAs, {
          round: round
        });
      }
    } else {
      // The first step's `minTime` is `0` by default.
      minTime = 0;
    }
  }
  // Warn if no `minTime` was defined or could be deduced.
  if (minTime === undefined) {
    console.warn('[javascript-time-ago] A step should specify `minTime`:\n' + JSON.stringify(step, null, 2));
  }
  return minTime;
}
function _getMinTimeForUnit(toUnit, fromUnit, _ref2) {
  var round = _ref2.round;
  var toUnitAmount = (0, _units.getSecondsInUnit)(toUnit);
  // if (!fromUnit) {
  // 	return toUnitAmount;
  // }
  // if (!fromUnit) {
  // 	fromUnit = getPreviousUnitFor(toUnit)
  // }
  var fromUnitAmount;
  if (fromUnit === 'now') {
    fromUnitAmount = (0, _units.getSecondsInUnit)(toUnit);
  } else {
    fromUnitAmount = (0, _units.getSecondsInUnit)(fromUnit);
  }
  if (toUnitAmount !== undefined && fromUnitAmount !== undefined) {
    return toUnitAmount - fromUnitAmount * (1 - (0, _round.getDiffRatioToNextRoundedNumber)(round));
  }
}
//# sourceMappingURL=getStepMinTime.js.map