"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getStepDenominator;
var _units = require("./units.js");
function getStepDenominator(step) {
  // `factor` is a legacy property.
  if (step.factor !== undefined) {
    return step.factor;
  }
  // "unit" is now called "formatAs".
  return (0, _units.getSecondsInUnit)(step.unit || step.formatAs) || 1;
}
//# sourceMappingURL=getStepDenominator.js.map