"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _locale = _interopRequireWildcard(require("./locale.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, "default": e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
describe('locale', function () {
  it("should tell if can use Intl for date formatting", function () {
    (0, _locale.intlDateTimeFormatSupportedLocale)('en').should.equal('en');
    (0, _locale.intlDateTimeFormatSupportedLocale)('en-XX').should.equal('en-XX');
    (0, _locale.intlDateTimeFormatSupportedLocale)(['en', 'ru']).should.equal('en');
  });
  it("should choose the most appropriate locale", function () {
    function arrayToObject(array) {
      return array.reduce(function (object, locale) {
        object[locale] = true;
        return object;
      }, {});
    }
    function choose(locale, locales) {
      var defaultLocale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'en';
      if (typeof locale === 'string') {
        locale = [locale];
      }
      locale = locale.concat(defaultLocale);
      return (0, _locale["default"])(locale, function (_) {
        return locales.includes(_);
      });
    }
    choose('ru-RU', ['en', 'ru']).should.equal('ru');
    choose('en-GB', ['en', 'ru']).should.equal('en');
    choose('fr-FR', ['en', 'ru']).should.equal('en');
    choose(['fr-FR', 'de-DE'], ['en', 'ru']).should.equal('en');
    choose(['fr-FR', 'de-DE'], ['en', 'de']).should.equal('de');
    choose(['fr-FR', 'de-DE'], ['en', 'de', 'fr']).should.equal('fr');
    choose('fr-FR', ['en', 'fr-FR']).should.equal('fr-FR');
    expect(function () {
      return choose('fr-FR', ['de', 'ru']);
    }).to["throw"]('No locale data has been registered for any of the locales: fr-FR');
  });
});
//# sourceMappingURL=locale.test.js.map