"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addLocaleData = addLocaleData;
exports.getLocaleData = getLocaleData;
// For all locales added
// their relative time formatter messages will be stored here.
var localesData = {};
function getLocaleData(locale) {
  return localesData[locale];
}
function addLocaleData(localeData) {
  if (!localeData) {
    throw new Error('[javascript-time-ago] No locale data passed.');
  }
  // This locale data is stored in a global variable
  // and later used when calling `.format(time)`.
  localesData[localeData.locale] = localeData;
}
//# sourceMappingURL=LocaleDataStore.js.map