"use client";
import MiniSvgLoader from "@/components/Helper/Loader/SvgLoader";
import useCurrency from "@/hooks/useCurrency";
import {
  useDeleteWishListMutation,
  useGetWishListQuery,
} from "@/store/features/wishlist/apiSlice";
import Link from "next/link";
import React from "react";
import StringLang from "@/utilities/StringLang";
import ProductCard from "@/components/Common/Card/ProductCard";

function FavoritesTab() {
  const { data, isFetching } = useGetWishListQuery();
  const [deleteWishlist, { isLoading: deleting }] = useDeleteWishListMutation();
  const currency = useCurrency();
  return (
    <div className="w-full ">
      <div className="w-full">
        <p className="text-[24px] font-bold text-white leading-8 mb-[18px]">
          <StringLang string="My Favorite" />
        </p>
        <div className="grid xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-6  mb-[30px]">
          {!data?.products && isFetching && (
            <div className="w-full xl:col-span-3 sm:col-span-2 col-span-1 flex justify-center">
              {" "}
              <MiniSvgLoader />
            </div>
          )}
          {data?.products?.map((product) => (
            <ProductCard
              key={product.id}
              {...product}
              type="column"
              className="bg-black"
            />
          ))}
          {!isFetching && data?.products?.length < 1 && (
            <div className="w-full flex flex-col items-center xl:col-span-3 sm:col-span-2 col-span-1 pt-6">
              <svg
                width="479"
                height="337"
                viewBox="0 0 479 337"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M415.691 321.787C408.378 302.112 397.67 292.274 383.566 292.274C362.41 292.274 372.609 261.297 350.67 261.297C336.387 261.297 336.387 278.538 315.933 267.83C294.843 256.789 316.716 237.744 276.756 234.088C236.795 230.431 245.975 267.83 229.521 267.83C217.67 267.83 216.907 248.988 206.798 247.458C196.689 245.927 195.306 258.427 187.732 256.86C178.503 254.951 181.986 239.096 159.485 239.096C136.985 239.096 144.637 269.723 139.152 273.086C133.667 276.449 126.615 265.218 119.041 278.538C111.467 291.858 124.588 298.127 113.556 298.127C100.115 298.127 92.6977 306.014 91.3047 321.787C92.2947 326.616 101.54 329.317 119.041 329.892C145.292 330.754 146.474 323.348 179.047 324.668C211.619 325.989 217.14 324.668 263.918 324.668C310.697 324.668 302.392 335.172 338.106 331.981C373.819 328.791 401.186 335.389 421.683 334.071C432.911 333.349 430.913 329.254 415.691 321.787Z"
                  fill="#121313"
                />
                <path
                  opacity="0.2"
                  d="M186.878 17.3345C186.879 17.2748 186.88 17.2157 186.88 17.1571C186.88 7.68148 179.389 0 170.149 0C160.91 0 153.419 7.68148 153.419 17.1571C153.419 17.1873 153.419 17.2176 153.42 17.2481C153.489 24.0305 151.221 30.6299 146.997 35.9368C141.478 42.8707 138.718 49.234 138.718 55.0266C138.718 57.6837 139.339 60.6964 140.581 64.0648C143.734 72.6127 142.763 82.1373 137.952 89.8738C133.291 97.3682 130.96 104.049 130.96 109.917C130.96 113.689 131.967 118.1 133.98 123.149C137.388 131.697 136.616 141.345 131.892 149.242C126.379 158.457 123.623 166.518 123.623 173.427C123.623 199.779 144.454 221.141 170.149 221.141C195.845 221.141 216.676 199.779 216.676 173.427C216.676 166.518 213.92 158.457 208.407 149.242C203.683 141.345 202.911 131.697 206.319 123.149C208.332 118.1 209.338 113.689 209.338 109.917C209.338 103.989 206.963 97.2468 202.212 89.6901C197.364 81.9803 196.346 72.4651 199.452 63.9041C200.652 60.5961 201.252 57.6369 201.252 55.0266C201.252 49.3063 198.557 43.0087 193.165 36.1339C188.965 30.7791 186.745 24.1382 186.878 17.3345Z"
                  fill="#8FD8FC"
                />
                <path
                  opacity="0.4"
                  d="M170.014 144.233V120.175L186.907 98.1096C187.072 97.8943 187.031 97.5863 186.816 97.4215C186.601 97.2567 186.293 97.2975 186.128 97.5128L169.133 119.71C169.068 119.796 169.032 119.9 169.032 120.008V142.951L153.142 122.196C152.977 121.981 152.669 121.94 152.454 122.105C152.238 122.27 152.198 122.578 152.362 122.793L169.032 144.566V146.831C169.032 147.004 169.121 147.156 169.256 147.243V168.57L169.133 168.73C169.068 168.816 169.032 168.92 169.032 169.028V186.943L153.142 166.188C152.977 165.973 152.669 165.932 152.454 166.097C152.238 166.262 152.198 166.57 152.362 166.785L169.032 188.558V195.851C169.032 196.024 169.121 196.176 169.256 196.263V209.125C169.208 209.202 169.181 209.292 169.181 209.384V248.874C169.181 249.145 169.401 249.365 169.672 249.365C169.943 249.365 170.163 249.145 170.163 248.874V215.767C170.21 215.691 170.238 215.602 170.238 215.507V209.508L187.896 191.399C188.085 191.205 188.081 190.894 187.887 190.705C187.693 190.516 187.382 190.52 187.193 190.714L170.238 208.102V188.684C170.238 188.576 170.202 188.471 170.136 188.386L170.014 188.226V171.927C170.148 171.839 170.238 171.687 170.238 171.515V168.902L186.907 147.13C187.072 146.914 187.031 146.606 186.816 146.441C186.601 146.277 186.293 146.318 186.128 146.533L170.238 167.288V144.692C170.238 144.584 170.202 144.479 170.136 144.393L170.014 144.233Z"
                  fill="white"
                />
                <path
                  opacity="0.2"
                  d="M79.941 242.47C55.8927 242.47 36.3977 222.477 36.3977 197.816C36.3977 173.154 55.8927 42.5527 79.941 42.5527C103.989 42.5527 123.484 173.154 123.484 197.816C123.484 222.477 103.989 242.47 79.941 242.47Z"
                  fill="#BFEAFF"
                />
                <path
                  opacity="0.4"
                  d="M79.8068 183.906V164.875L96.7002 142.81C96.865 142.595 96.8241 142.286 96.6089 142.122C96.3936 141.957 96.0855 141.998 95.9207 142.213L78.9262 164.41C78.8606 164.496 78.8251 164.601 78.8251 164.708V182.623L62.9349 161.869C62.7701 161.653 62.462 161.613 62.2467 161.777C62.0315 161.942 61.9906 162.25 62.1554 162.465L78.8251 184.238V191.531C78.8251 191.704 78.9141 191.856 79.0488 191.943V205.475L62.9349 184.428C62.7701 184.213 62.462 184.172 62.2467 184.337C62.0315 184.502 61.9906 184.81 62.1554 185.025L79.0488 207.09V227.365C79.0005 227.442 78.9744 227.532 78.9744 227.624V267.114C78.9744 267.385 79.1942 267.605 79.4653 267.605C79.7363 267.605 79.9561 267.385 79.9561 267.114V234.007C80.0032 233.931 80.0305 233.842 80.0305 233.747V227.748L97.6887 209.639C97.878 209.445 97.874 209.134 97.68 208.945C97.4859 208.756 97.1751 208.76 96.9858 208.954L80.0305 226.342V206.924V184.364C80.0305 184.256 79.9949 184.151 79.9294 184.066L79.8068 183.906Z"
                  fill="white"
                />
                <path
                  opacity="0.2"
                  d="M435.105 255.307C411.057 255.307 391.562 235.314 391.562 210.653C391.562 185.991 411.057 55.3896 435.105 55.3896C459.153 55.3896 478.648 185.991 478.648 210.653C478.648 235.314 459.153 255.307 435.105 255.307Z"
                  fill="#8FD8FC"
                />
                <path
                  opacity="0.4"
                  d="M434.971 196.743V177.712L451.864 155.647C452.029 155.431 451.988 155.123 451.773 154.959C451.558 154.794 451.25 154.835 451.085 155.05L434.09 177.247C434.025 177.333 433.989 177.438 433.989 177.545V195.46L418.099 174.706C417.934 174.49 417.626 174.449 417.411 174.614C417.196 174.779 417.155 175.087 417.319 175.302L433.989 197.075V204.368C433.989 204.541 434.078 204.693 434.213 204.78V218.312L418.099 197.265C417.934 197.05 417.626 197.009 417.411 197.174C417.196 197.339 417.155 197.647 417.319 197.862L434.213 219.927V240.202C434.165 240.279 434.138 240.369 434.138 240.461V279.951C434.138 280.222 434.358 280.442 434.629 280.442C434.9 280.442 435.12 280.222 435.12 279.951V246.844C435.167 246.768 435.195 246.679 435.195 246.584V240.585L452.853 222.476C453.042 222.282 453.038 221.971 452.844 221.782C452.65 221.593 452.339 221.597 452.15 221.791L435.195 239.179V219.761V197.201C435.195 197.093 435.159 196.988 435.093 196.903L434.971 196.743Z"
                  fill="white"
                />
                <path
                  d="M345.028 81.2375L341.905 80.5435L341.211 77.4203C341.172 77.3047 341.095 77.2275 340.98 77.2275C340.864 77.2275 340.787 77.3047 340.748 77.4203L340.054 80.5435L336.931 81.2761C336.815 81.3146 336.738 81.3918 336.738 81.5074C336.738 81.6231 336.815 81.7001 336.931 81.7386L340.054 82.4328L340.748 85.556C340.787 85.6716 340.864 85.7488 340.98 85.7488C341.095 85.7488 341.172 85.6716 341.211 85.556L341.905 82.4328L345.028 81.7002C345.144 81.6617 345.221 81.5845 345.221 81.4689C345.221 81.3532 345.105 81.276 345.028 81.2375Z"
                  fill="#3C7E52"
                />
                <path
                  d="M170.629 94.7711L174.948 93.8458L175.912 89.5659C175.95 89.4116 176.066 89.2959 176.22 89.2959C176.374 89.2959 176.529 89.4116 176.529 89.5659L177.492 93.8842L181.811 94.8867C181.965 94.9253 182.081 95.0409 182.081 95.2337C182.081 95.3879 181.965 95.5423 181.811 95.5423L177.492 96.4676L176.529 100.748C176.49 100.902 176.374 101.017 176.22 101.017C176.066 101.017 175.912 100.902 175.912 100.748L174.948 96.429L170.629 95.4265C170.475 95.3879 170.359 95.2723 170.359 95.0795C170.359 94.9638 170.475 94.8097 170.629 94.7711Z"
                  fill="#3C7E52"
                />
                <path
                  d="M188.678 58.5662L190.914 58.0648L191.415 55.8286C191.415 55.7515 191.492 55.7129 191.569 55.7129C191.647 55.7129 191.724 55.7515 191.724 55.8286L192.225 58.0648L194.461 58.6046C194.538 58.6046 194.577 58.6819 194.577 58.759C194.577 58.8361 194.538 58.9132 194.423 58.9132L192.186 59.4143L191.685 61.6508C191.685 61.7279 191.608 61.7664 191.531 61.7664C191.454 61.7664 191.377 61.7279 191.377 61.6508L190.875 59.4143L188.639 58.8746C188.562 58.8746 188.523 58.7975 188.523 58.7204C188.523 58.6433 188.601 58.5662 188.678 58.5662Z"
                  fill="#3C7E52"
                />
                <path
                  d="M213.983 146.783C213.983 146.783 153.76 138.567 135.385 187.641C129.003 204.659 129.846 223.437 137.035 240.125C143.49 255.126 155.814 273.648 179.14 285.018C187.832 289.272 197.222 291.95 206.794 293.27C225.866 295.837 283.229 304.2 298.413 313.736L275.453 274.198L283.522 253.366L272.886 250.798L276.297 238.475L249.083 252.925L254.181 220.173H235.879L232.468 187.017L209.068 198.937L213.983 146.783Z"
                  fill="#45F882"
                />
                <path
                  d="M301.603 317.001L297.825 314.617C282.715 305.154 224.215 296.682 206.647 294.335C196.671 292.978 187.245 290.19 178.663 286.009C154.529 274.272 142.169 254.797 136.044 240.567C128.599 223.219 128.012 204.293 134.394 187.239C138.648 175.832 145.507 166.59 154.786 159.658C162.195 154.156 171.107 150.122 181.34 147.738C198.688 143.667 213.982 145.684 214.166 145.684L215.229 145.83L210.425 196.995L233.458 185.258L236.905 219.037H255.5L250.549 250.873L278.093 236.239L274.316 249.956L285.062 252.523L276.7 274.052L301.603 317.001ZM204.263 147.371C198.358 147.371 190.326 147.884 181.744 149.902C159.114 155.256 143.893 168.057 136.411 188.009C130.213 204.513 130.8 222.888 138.025 239.686C144.003 253.587 156.07 272.549 179.58 284.029C187.979 288.136 197.184 290.85 206.904 292.171C228.066 295.031 276.883 302.294 295.478 310.949L274.169 274.272L281.981 254.1L271.455 251.57L274.462 240.603L247.542 254.907L252.786 221.275H234.778L231.44 188.706L207.711 200.809L212.699 147.811C211.305 147.591 208.297 147.371 204.263 147.371Z"
                  fill="#0D152E"
                />
                <path
                  d="M263.973 154.228C263.973 154.228 281.284 94.3346 341.214 105.484C355.518 108.162 368.575 115.46 378.037 126.463C388.747 138.934 398.943 159.289 395.202 189.988C393.148 206.932 385.959 222.85 374.773 235.76C370.078 241.152 364.027 247.607 356.251 255.015C356.251 255.015 315.834 291.582 302.667 313.698L288.216 269.906L313.303 239.281L288.619 219.292L296.285 177.187L263.973 154.228Z"
                  fill="#45F882"
                />
                <path
                  d="M302.373 316.339L286.969 269.687L311.726 239.465L287.409 219.77L295.038 177.701L262.652 154.705L262.872 153.971C263.056 153.348 267.42 138.604 279.23 124.997C286.199 116.965 294.341 111.06 303.4 107.429C314.697 102.881 327.46 101.891 341.361 104.458C356.031 107.209 369.345 114.764 378.808 125.804C388.894 137.577 400.117 158.263 396.229 190.171C394.138 207.263 387.023 223.291 375.543 236.531C370.225 242.656 363.99 249.184 356.948 255.859C356.508 256.226 316.494 292.61 303.547 314.322L302.373 316.339ZM289.426 270.127L302.96 311.131C317.191 288.979 355.114 254.576 355.518 254.209C362.45 247.607 368.648 241.152 373.93 235.064C385.116 222.154 392.084 206.529 394.102 189.878C397.879 158.776 386.986 138.604 377.194 127.197C368.061 116.525 355.188 109.226 340.994 106.585C316.604 102.037 296.395 108.676 280.991 126.354C270.905 137.907 266.283 150.634 265.256 153.825L297.495 176.748L289.83 218.889L314.843 239.171L289.426 270.127Z"
                  fill="#0D152E"
                />
                <path
                  d="M260.999 211.188L256.305 241.41L280.108 226.079L260.999 211.188Z"
                  fill="#45F882"
                />
                <path
                  d="M254.84 243.647L260.195 209.171L282.017 226.152L254.84 243.647ZM261.772 213.205L257.737 239.136L278.203 226.005L261.772 213.205Z"
                  fill="#0D152E"
                />
                <path
                  d="M227.806 161.857L220.141 184.853L245.668 169.119L227.806 161.857Z"
                  fill="#45F882"
                />
                <path
                  d="M218.16 187.347L227.146 160.39L248.125 168.862L218.16 187.347ZM228.466 163.324L222.158 182.286L243.247 169.265L228.466 163.324Z"
                  fill="#0D152E"
                />
                <path
                  d="M261.406 179.315L267.348 205.246H283.522V175.904L261.406 179.315Z"
                  fill="#45F882"
                />
                <path
                  d="M284.624 206.346H266.469L260.051 178.399L284.588 174.621V206.346H284.624ZM268.23 204.146H282.424V177.188L262.765 180.233L268.23 204.146Z"
                  fill="#0D152E"
                />
                <path
                  d="M280.113 244.38L287.779 246.947L298.415 236.714L289.062 229.929L280.113 244.38Z"
                  fill="#45F882"
                />
                <path
                  d="M288.07 248.195L278.461 245.004L288.73 228.353L300.1 236.642L288.07 248.195ZM281.799 243.757L287.52 245.664L296.726 236.825L289.391 231.507L281.799 243.757Z"
                  fill="#0D152E"
                />
                <path
                  d="M166.805 100.237L165.004 101.501L183.023 127.165L184.824 125.9L166.805 100.237Z"
                  fill="#0D152E"
                />
                <path
                  d="M202.317 67L200.16 67.4395L210.868 119.983L213.025 119.544L202.317 67Z"
                  fill="#0D152E"
                />
                <path
                  d="M237.283 89.5733L235.082 89.5889L235.315 122.525L237.515 122.509L237.283 89.5733Z"
                  fill="#0D152E"
                />
                <path
                  d="M373.639 197.796C395.424 197.796 413.084 180.137 413.084 158.352C413.084 136.568 395.424 118.908 373.639 118.908C351.855 118.908 334.195 136.568 334.195 158.352C334.195 180.137 351.855 197.796 373.639 197.796Z"
                  fill="white"
                />
                <path
                  d="M373.64 198.954C351.277 198.954 333.039 180.755 333.039 158.353C333.039 135.951 351.238 117.752 373.64 117.752C396.042 117.752 414.241 135.951 414.241 158.353C414.241 180.755 396.042 198.954 373.64 198.954ZM373.64 120.104C352.549 120.104 335.353 137.262 335.353 158.391C335.353 179.521 352.51 196.679 373.64 196.679C394.769 196.679 411.928 179.521 411.928 158.391C411.928 137.262 394.769 120.104 373.64 120.104Z"
                  fill="#3C7E52"
                />
                <path
                  d="M397.001 70.9043H394.688V111.351H397.001V70.9043Z"
                  fill="#3C7E52"
                />
                <path
                  d="M442.454 90.1303L413.727 118.049L415.339 119.708L444.067 91.7892L442.454 90.1303Z"
                  fill="#3C7E52"
                />
                <path
                  d="M462.785 135.873H421.953V138.186H462.785V135.873Z"
                  fill="#3C7E52"
                />
                <path
                  d="M365.351 175.857C362.921 174.315 361.032 172.002 359.605 169.033C358.217 166.025 357.523 162.478 357.523 158.391C357.523 154.265 358.217 150.718 359.605 147.749C360.994 144.741 362.921 142.466 365.351 140.924C367.78 139.382 370.517 138.572 373.602 138.572C376.687 138.572 379.463 139.343 381.892 140.924C384.321 142.466 386.249 144.78 387.637 147.749C389.025 150.756 389.719 154.304 389.719 158.391C389.719 162.516 389.025 166.064 387.637 169.033C386.249 172.04 384.321 174.315 381.892 175.857C379.463 177.399 376.687 178.209 373.602 178.209C370.556 178.209 367.78 177.399 365.351 175.857ZM380.157 168.57C381.738 166.295 382.547 162.902 382.547 158.391C382.547 153.88 381.738 150.486 380.157 148.212C378.576 145.937 376.378 144.78 373.64 144.78C370.941 144.78 368.782 145.937 367.163 148.212C365.582 150.486 364.772 153.88 364.772 158.391C364.772 162.902 365.582 166.295 367.163 168.57C368.744 170.845 370.903 172.001 373.64 172.001C376.378 171.963 378.537 170.845 380.157 168.57Z"
                  fill="#45F882"
                />
                <path
                  d="M373.641 179.366C370.325 179.366 367.356 178.518 364.734 176.86C362.151 175.202 360.069 172.735 358.565 169.534C357.1 166.411 356.367 162.633 356.367 158.391C356.367 154.111 357.1 150.371 358.565 147.248C360.03 144.086 362.112 141.619 364.734 139.922C367.318 138.264 370.325 137.416 373.641 137.416C376.918 137.416 379.926 138.264 382.548 139.922C385.17 141.58 387.252 144.048 388.717 147.248C390.182 150.371 390.915 154.15 390.915 158.391C390.915 162.671 390.182 166.411 388.717 169.534C387.252 172.735 385.17 175.164 382.548 176.86C379.926 178.518 376.918 179.366 373.641 179.366ZM373.641 139.691C370.788 139.691 368.243 140.423 366.007 141.85C363.77 143.277 361.997 145.436 360.686 148.212C359.375 151.027 358.719 154.458 358.719 158.391C358.719 162.324 359.375 165.756 360.686 168.57C361.997 171.346 363.77 173.467 366.007 174.932C368.243 176.359 370.788 177.092 373.641 177.092C376.494 177.092 379.078 176.359 381.314 174.932C383.55 173.506 385.362 171.346 386.635 168.57C387.946 165.756 388.601 162.324 388.601 158.391C388.601 154.458 387.946 151.065 386.635 148.212C385.324 145.436 383.55 143.315 381.314 141.85C379.039 140.423 376.456 139.691 373.641 139.691ZM373.641 173.12C370.518 173.12 368.05 171.809 366.238 169.226C364.503 166.758 363.616 163.095 363.616 158.353C363.616 153.61 364.503 149.947 366.238 147.479C368.05 144.896 370.556 143.585 373.641 143.585C376.764 143.585 379.309 144.896 381.121 147.479C382.856 149.947 383.743 153.61 383.743 158.353C383.743 163.095 382.856 166.758 381.121 169.226C379.27 171.809 376.764 173.12 373.641 173.12ZM373.641 145.899C371.289 145.899 369.477 146.862 368.127 148.829C366.662 150.911 365.929 154.111 365.929 158.353C365.929 162.594 366.662 165.794 368.127 167.876C369.515 169.843 371.327 170.807 373.641 170.807C376.031 170.807 377.844 169.843 379.232 167.876C380.697 165.794 381.429 162.594 381.429 158.353C381.429 154.111 380.697 150.911 379.232 148.829C377.844 146.862 375.993 145.899 373.641 145.899Z"
                  fill="#3C7E52"
                />
                <path
                  d="M338.027 331.353C333.94 324.853 324.613 321.603 310.046 321.603C288.196 321.603 292.095 309.811 269.435 309.811C246.776 309.811 260.391 265.247 205.298 262.89C150.204 260.532 162.676 288.829 145.682 288.829C128.687 288.829 119.549 274.963 98.7445 275.943C77.9396 276.922 69.5473 308.051 61.1849 309.811C52.8225 311.571 59.0269 303.652 36.0977 303.652C20.8117 303.652 10.0215 309.635 3.7272 321.603C-5.0423 328.103 4.06068 331.353 31.0361 331.353C40.9673 331.353 68.3201 328.186 98.7445 327.305C115.914 326.808 147.261 336.281 186.684 336.281C205.298 336.281 221.248 332.049 257.63 331.353C281.885 330.889 308.684 330.889 338.027 331.353Z"
                  fill="#0D152E"
                />
              </svg>
              <p className=" text-white text-5xl font-medium text-center mt-8">
                Favorite list not found
              </p>
              <Link
                href={"/"}
                className="w-fit px-10 h-[62px] rounded bg-primary-blue text-primary-black flex justify-center items-center text-[18px] font-semibold tracking-wider  mt-10"
              >
                <StringLang string="Back to Home" />
              </Link>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

export default FavoritesTab;
