import React from "react";

function CounterSection({ datas }) {
  // Helper function for formatting
  const formatNumber = (num) => {
    if (num === null || num === undefined) return 0;
    if (num < 1000) return num;
    if (num < 1000000) return (num / 1000).toFixed(1).replace(/\.0$/, "") + "K";
    if (num < 1000000000)
      return (num / 1000000).toFixed(1).replace(/\.0$/, "") + "M";
    return (num / 1000000000).toFixed(1).replace(/\.0$/, "") + "B";
  };

  if (!datas) return null;

  return (
    <div className="w-full pt-[60px]">
      <div className="w-full bg-gradient-to-br from-[#0a0f14] via-[#0b1219] to-[#0a0f14]">
        <div className="theme-container mx-auto py-10">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-6">
            {[
              {
                value: datas.counter1_value,
                title: datas.counter1_title,
              },
              {
                value: datas.counter2_value,
                title: datas.counter2_title,
              },
              {
                value: datas.counter3_value,
                title: datas.counter3_title,
              },
              {
                value: datas.counter4_value,
                title: datas.counter4_title,
              },
            ].map((item, index) => (
              <div
                key={index}
                className="group relative overflow-hidden rounded-2xl border border-white/10 bg-white/5 backdrop-blur-md px-6 py-6 text-center shadow-[0_12px_30px_rgba(0,0,0,0.35)] transition-all duration-300 hover:-translate-y-1 hover:border-white/20 hover:shadow-[0_20px_45px_rgba(0,0,0,0.45)]"
              >
                <span className="pointer-events-none absolute inset-x-0 top-0 h-[3px] bg-gradient-to-r from-[#7dd3fc] via-[#60a5fa] to-[#34d399] opacity-70" />
                <span className="pointer-events-none absolute inset-0 opacity-0 transition-opacity duration-300 group-hover:opacity-100 bg-[radial-gradient(120%_120%_at_15%_0%,rgba(125,211,252,0.18),transparent_60%)]" />
                <div className="relative">
                  <span className="text-white lg:text-[64px] font-semibold tracking-tight lg:leading-[64px] text-3xl">
                    {formatNumber(item.value)}
                  </span>
                  <span className="mt-2 block text-[13px] uppercase tracking-[0.2em] text-[#9CA3AF]">
                    {item.title}
                  </span>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}

export default CounterSection;
