import React from "react";
import Link from "next/link";

function Categories({ datas }) {
  if (datas && datas.length > 0) {
    return (
      <div className="w-full py-[60px]">
        <div className="theme-container mx-auto">
          <div className="grid grid-cols-3 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 xl:grid-cols-8 sm:gap-5 gap-3">
            {datas.map((category, i) => (
              <Link
                key={i}
                href={`/products?category=${category.slug}`}
                className="categories-item relative w-full sm:h-[150px] h-[110px] flex flex-col justify-center items-center gap-2 p-3 rounded-[18px] bg-[#0D1018] border border-[#243042] shadow-[0_10px_22px_rgba(0,0,0,0.5)] transition-all duration-300 hover:-translate-y-1 hover:shadow-[0_18px_36px_rgba(0,0,0,0.65)] hover:border-[#4DB3FF] group overflow-hidden"
              >
                <span className="pointer-events-none absolute -right-6 -top-6 h-20 w-20 rotate-45 bg-[#4DB3FF]/20" />
                <span className="pointer-events-none absolute inset-0 opacity-0 group-hover:opacity-100 transition-opacity duration-300 bg-[radial-gradient(120%_120%_at_80%_0%,rgba(77,179,255,0.25),transparent_60%)]" />
                <div className="relative z-10 flex items-center justify-center w-[68px] h-[68px] sm:w-[72px] sm:h-[72px] aspect-square rounded-full overflow-hidden bg-[#141A24] border border-[#2F3A4B] ring-1 ring-[#2DFF8F] shadow-[0_8px_18px_rgba(0,0,0,0.6)]">
                  <img
                    src={process.env.BASE_URL + category.icon}
                    alt=""
                    className="w-[46px] h-[46px] object-contain transform scale-100 group-hover:scale-105 transition-all duration-300"
                  />
                </div>
                <div className="relative z-10 px-3 py-1 rounded-full bg-[#141A24] border border-[#2F3A4B]">
                  <p className="text-[12px] text-center font-semibold text-[#D7ECFF] tracking-wide">
                    {category.name}
                  </p>
                </div>
              </Link>
            ))}
          </div>
        </div>
      </div>
    );
  }
}

export default Categories;
