"use client";
import React, { useEffect, useState } from "react";
import { useSendContactMessageMutation } from "@/store/features/contact/apiSlice";
import SvgLoader from "@/components/Helper/Loader/SvgLoader";
import StringLang from "@/utilities/StringLang";

function MessageForm({ title }) {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    subject: "",
    phone: "",
    message: "",
  });

  const [errors, setErrors] = useState({});

  const [sendContactMessage, { isLoading, error, isSuccess }] =
    useSendContactMessageMutation();

  /* ================= FIELD CHANGE ================= */
  const formHandler = (e) => {
    const { name, value } = e.target;

    setFormData((prev) => ({
      ...prev,
      [name]: value,
    }));

    // Clear error immediately for this field
    // if (errors[name]) {
    //   setErrors((prev) => {
    //     const copy = { ...prev };
    //     delete copy[name];
    //     return copy;
    //   });
    // }
  };

  /* ================= EFFECT ================= */
  // useEffect(() => {
  //   if (error?.data?.errors) {
  //     setErrors(error.data.errors);
  //   }

  //   if (isSuccess) {
  //     setFormData({
  //       name: "",
  //       email: "",
  //       subject: "",
  //       phone: "",
  //       message: "",
  //     });
  //     setErrors({});
  //   }
  // }, [error, isSuccess]);

  /* ================= SUBMIT ================= */
  const handleSubmit = (e) => {
    e.preventDefault();
    setErrors({});

    // 🔴 IMPORTANT: map phone → phone_number
    const payload = {
      name: formData.name.trim(),
      email: formData.email.trim(),
      subject: formData.subject.trim(),
      message: formData.message.trim(),
      phone_number: formData.phone.trim(), // ✅ FIX
    };

    sendContactMessage(payload);
  };

  return (
    <form
      onSubmit={handleSubmit}
      noValidate
      className="w-full md:py-[35px] md:px-10 p-5 rounded-[5px] bg-black"
    >
      <p className="text-[24px] font-semibold text-white mb-5">{title}</p>

      <div className="grid md:grid-cols-2 gap-7 mb-5">
        {/* NAME */}
        <div>
          <label className="text-white text-sm">Name*</label>
          <input
            type="text"
            name="name"
            onChange={formHandler}
            required
            className="w-full h-[50px] bg-[#0B0E12] border border-[#23262B] text-white px-4 rounded"
          />
          {errors.name && (
            <span className="text-red-500 text-sm">{errors.name[0]}</span>
          )}
        </div>

        {/* PHONE */}
        {/* <div>
          <label className="text-white text-sm">Phone</label>
          <input
            type="text"
            name="phone"
            value={formData.phone}
            onChange={formHandler}
            className="w-full h-[50px] bg-[#0B0E12] border border-[#23262B] text-white px-4 rounded"
          />
          {errors.phone_number && (
            <span className="text-red-500 text-sm">
              {errors.phone_number[0]}
            </span>
          )}
        </div> */}

        {/* EMAIL */}
        <div>
          <label className="text-white text-sm">Email*</label>
          <input
            type="email"
            name="email"
            onChange={formHandler}
            required
            className="w-full h-[50px] bg-[#0B0E12] border border-[#23262B] text-white px-4 rounded"
          />
          {errors.email && (
            <span className="text-red-500 text-sm">{errors.email[0]}</span>
          )}
        </div>

        {/* SUBJECT */}
        <div className="col-span-full">
          <label className="text-white text-sm">Subject*</label>
          <input
            type="text"
            name="subject"
            onChange={formHandler}
            required
            className="w-full h-[50px] bg-[#0B0E12] border border-[#23262B] text-white px-4 rounded"
          />
          {errors.subject && (
            <span className="text-red-500 text-sm">{errors.subject[0]}</span>
          )}
        </div>

        {/* MESSAGE */}
        <div className="col-span-full">
          <label className="text-white text-sm">Message*</label>
          <textarea
            name="message"
            onChange={formHandler}
            required
            className="w-full h-[170px] bg-[#0B0E12] border border-[#23262B] text-white p-4 rounded resize-none"
          />
          {errors.message && (
            <span className="text-red-500 text-sm">{errors.message[0]}</span>
          )}
        </div>
      </div>

      <button
        type="submit"
        disabled={isLoading}
        className="w-full bg-primary-blue py-3 rounded text-black font-semibold"
      >
        {isLoading ? <SvgLoader /> : <StringLang string="Send Message" />}
      </button>
    </form>
  );
}

export default MessageForm;
