import React from "react";
import Link from "next/link";
import StringLang from "@/utilities/StringLang";
export function generateMetadata() {
  return {
    title: "Success",
  };
}
function Page() {
  return (
    <>
      <div className=" h-screen flex justify-center items-center">
        <div className="bg-black p-6  md:mx-auto">
          <svg
            viewBox="0 0 24 24"
            className="text-green-600 w-16 h-16 mx-auto my-6"
          >
            <path
              fill="currentColor"
              d="M12,0A12,12,0,1,0,24,12,12.014,12.014,0,0,0,12,0Zm6.927,8.2-6.845,9.289a1.011,1.011,0,0,1-1.43.188L5.764,13.769a1,1,0,1,1,1.25-1.562l4.076,3.261,6.227-8.451A1,1,0,1,1,18.927,8.2Z"
            ></path>
          </svg>
          <div className="text-center">
            <h3 className="md:text-2xl text-base text-white font-semibold text-center">
              <StringLang string="Payment Done!" />
            </h3>
            <p className="text-primary-gray my-2">
              <StringLang string="Thank you for completing your secure online payment." />
            </p>
            <p className="text-primary-gray">
              {" "}
              <StringLang string="Have a great day!" />{" "}
            </p>
            <div className="py-10 text-center">
              <Link
                href="/auth/profile/order"
                className="px-12 bg-primary-blue text-primary-black font-semibold py-3"
              >
                <StringLang string="Your Orders" />
              </Link>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}

export default Page;
