import "./globals.css";
import AutoLogin from "@/components/Helper/AutoLogin";
import NextTopLoader from "nextjs-toploader";
import TopBarSmallAnnounce from "@/components/Partials/TopBarSmallAnnounce";
import AppHeader from "@/components/Partials/AppHeader";
import AppFooter from "@/components/Partials/AppFooter";
import "aos/dist/aos.css";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import StoreProvider from "@/components/Helper/StoreProvider";
import SiteSetup from "@/components/Partials/SiteSetup";
import React, { Suspense } from "react";
import Maintainance from "@/components/Helper/Maintainance";
import FacebookPixel from "@/components/Helper/FacebookPixel";
import Script from "next/script";

async function getData() {
  try {
    const res = await fetch(`${process.env.BASE_URL}api/website-setup`, {
      cache: "no-store",
    });

    if (!res.ok) {
      throw new Error("Failed to fetch website setup");
    }

    return res.json();
  } catch (error) {
    console.error(error);
    return null;
  }
}

export default async function RootLayout({ children }) {
  const data = await getData();

  const {
    setting,
    categories,
    languages,
    currencies,
    social_links,
    localizations,
    googleAnalytic,
    tawkChat,
    cookieConsent,
    maintainance,
    homepage_ads,
    shoppage_ads,
    shop_detail_ads,
    footer,
  } = data || {};

  return (
    <html lang="en">
      <head>
        {/* Google Ads Tag */}
        <Script
          src="https://www.googletagmanager.com/gtag/js?id=AW-17600961465"
          strategy="afterInteractive"
        />
        <Script id="google-ads" strategy="afterInteractive">
          {`
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', 'AW-17600961465');
          `}
        </Script>

        {/* Google Translate */}
        <Script
          src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"
          strategy="afterInteractive"
        />

        {/* Favicon */}
        {setting?.favicon && (
          <link
            rel="icon"
            type="image/png"
            href={process.env.BASE_URL + setting.favicon}
          />
        )}

        {/* PWA */}
        {(process.env.PWA === 1 || process.env.PWA === "1") && (
          <link rel="manifest" href="/manifest.json" />
        )}
      </head>

      <body dir="ltr" id="portal-root" suppressHydrationWarning>
        <StoreProvider>
          <Maintainance maintainance={maintainance}>
            <AutoLogin />

            <SiteSetup
              data={{
                setting,
                categories,
                languages,
                currencies,
                social_links,
                localizations,
                googleAnalytic,
                tawkChat,
                cookieConsent,
                homepage_ads,
                shoppage_ads,
                shop_detail_ads,
                footer,
              }}
            />

            <header>
              <TopBarSmallAnnounce
                currencies={currencies}
                settings={setting}
                languages={languages}
              />
              <AppHeader
                languages={languages}
                currencies={currencies}
                settings={setting}
                categories={categories}
              />
            </header>

            <main>
              {children}
              <Suspense fallback={null}>
                <FacebookPixel />
              </Suspense>
            </main>

            <footer>
              <AppFooter />
            </footer>

            {/* Google Identity */}
            <Script
              src="https://accounts.google.com/gsi/client"
              strategy="beforeInteractive"
            />

            <ToastContainer />
          </Maintainance>
        </StoreProvider>

        <NextTopLoader color="#FBB322" showSpinner={false} />
      </body>
    </html>
  );
}