import Link from "next/link";
import React from "react";
export function generateMetadata() {
  return {
    title: "Not Found",
  };
}
function NotFound() {
  return (
    <div className="w-full py-[60px]">
      <div className="w-full flex flex-col items-center xl:col-span-3 sm:col-span-2 col-span-1 pt-6">
        <svg
          width="570"
          height="452"
          viewBox="0 0 570 452"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            opacity="0.06"
            d="M475.1 164.155C473.272 160.137 472.358 156.955 472.358 154.61C472.358 144.891 480.041 137.012 489.518 137.012C498.996 137.012 506.679 144.891 506.679 154.61C506.679 154.514 506.677 154.42 506.674 154.327C506.918 161.75 509.478 168.912 513.997 174.807C519.171 181.557 521.757 187.772 521.757 193.452C521.757 195.83 521.272 198.486 520.302 201.419C517.079 211.167 518.223 221.831 523.44 230.674C527.623 237.763 529.714 244.123 529.714 249.753C529.714 253.231 528.88 257.239 527.211 261.776C523.583 271.639 524.5 282.601 529.716 291.724C534.732 300.496 537.24 308.22 537.24 314.894C537.24 341.923 515.874 363.833 489.518 363.833C463.163 363.833 441.797 341.923 441.797 314.894C441.797 308.22 444.305 300.496 449.321 291.724C454.537 282.601 455.454 271.639 451.826 261.776C450.157 257.239 449.323 253.231 449.323 249.753C449.323 244.061 451.458 237.638 455.728 230.482C460.986 221.67 462.185 211.017 459.016 201.257C458.083 198.384 457.616 195.783 457.616 193.452C457.616 184.934 463.444 175.168 475.1 164.155Z"
            fill="white"
          />
          <path
            opacity="0.2"
            d="M489.641 284.947V260.278L472.316 237.65C472.143 237.423 472.185 237.1 472.412 236.927C472.638 236.753 472.961 236.796 473.135 237.023L490.566 259.79C490.635 259.88 490.672 259.99 490.672 260.103V283.6L506.948 262.34C507.122 262.114 507.445 262.071 507.671 262.244C507.898 262.417 507.941 262.741 507.767 262.967L490.672 285.296V287.615C490.672 287.794 490.581 287.952 490.443 288.044V309.908L490.566 310.069C490.635 310.159 490.672 310.269 490.672 310.383V328.722L506.948 307.463C507.122 307.236 507.445 307.193 507.671 307.367C507.898 307.54 507.941 307.863 507.767 308.09L490.672 330.418V337.895C490.672 338.074 490.581 338.231 490.443 338.324V351.506C490.492 351.586 490.519 351.68 490.519 351.776V392.28C490.519 392.565 490.288 392.796 490.003 392.796C489.718 392.796 489.487 392.565 489.487 392.28V358.325C489.439 358.247 489.411 358.154 489.411 358.055V351.907L471.303 333.337C471.104 333.133 471.108 332.806 471.312 332.608C471.516 332.409 471.842 332.413 472.041 332.617L489.411 350.43V330.543C489.411 330.43 489.448 330.32 489.517 330.23L489.641 330.069V313.362C489.502 313.27 489.411 313.112 489.411 312.933V310.258L472.316 287.929C472.143 287.703 472.185 287.379 472.412 287.206C472.638 287.033 472.961 287.076 473.135 287.302L489.411 308.561V285.421C489.411 285.308 489.448 285.198 489.517 285.108L489.641 284.947Z"
            fill="white"
          />
          <path
            opacity="0.16"
            d="M387.941 214.936C387.323 213.037 386.989 211.005 386.989 208.892C386.989 198.354 395.319 189.812 405.595 189.812C415.87 189.812 424.2 198.354 424.2 208.892C424.2 211.92 423.512 214.784 422.288 217.327C429.863 223.21 434.757 232.534 434.757 243.03C434.757 244.536 434.558 246.161 434.159 247.903C431.491 259.573 432.966 271.807 438.33 282.509C441.097 288.027 442.48 293.048 442.48 297.572C442.48 319.841 424.877 337.893 403.162 337.893C381.447 337.893 363.844 319.841 363.844 297.572C363.844 292.984 365.265 287.894 368.108 282.302C373.529 271.639 375.074 259.423 372.479 247.746C372.105 246.061 371.918 244.489 371.918 243.03C371.918 230.971 378.377 220.46 387.941 214.936Z"
            fill="white"
          />
          <path
            opacity="0.2"
            d="M403.325 313.719V326.901C403.375 326.982 403.402 327.075 403.402 327.171V367.675C403.402 367.96 403.171 368.191 402.886 368.191C402.601 368.191 402.37 367.96 402.37 367.675V333.721C402.322 333.642 402.294 333.55 402.294 333.451V327.303L384.186 308.732C383.987 308.528 383.991 308.202 384.195 308.003C384.399 307.804 384.725 307.808 384.924 308.012L402.294 325.825V305.939C402.294 305.826 402.331 305.715 402.4 305.625L402.523 305.464V285.953L385.198 263.324C385.025 263.098 385.068 262.775 385.294 262.601C385.521 262.428 385.844 262.471 386.017 262.697L403.449 285.465C403.517 285.555 403.555 285.665 403.555 285.778V304.117L419.831 282.858C420.004 282.632 420.328 282.589 420.554 282.762C420.78 282.935 420.823 283.259 420.65 283.485L403.555 305.814V313.29C403.555 313.469 403.464 313.627 403.325 313.719Z"
            fill="white"
          />
          <path
            opacity="0.06"
            d="M124.193 146.767C122.366 142.749 121.452 139.567 121.452 137.222C121.452 127.503 129.135 119.624 138.612 119.624C148.089 119.624 155.772 127.503 155.772 137.222C155.772 137.126 155.771 137.032 155.768 136.939C156.011 144.363 158.572 151.524 163.091 157.419C168.264 164.169 170.851 170.384 170.851 176.064C170.851 178.442 170.366 181.098 169.396 184.031C166.173 193.779 167.316 204.444 172.534 213.286C176.717 220.375 178.808 226.735 178.808 232.365C178.808 235.843 177.974 239.851 176.304 244.388C172.676 254.251 173.594 265.213 178.81 274.336C183.826 283.108 186.334 290.832 186.334 297.507C186.334 324.535 164.968 346.446 138.612 346.446C112.256 346.446 90.8906 324.535 90.8906 297.507C90.8906 290.832 93.3986 283.108 98.4146 274.336C103.631 265.213 104.548 254.251 100.92 244.388C99.251 239.851 98.4164 235.843 98.4164 232.365C98.4164 226.673 100.552 220.25 104.822 213.094C110.08 204.283 111.279 193.63 108.11 183.87C107.177 180.997 106.71 178.395 106.71 176.064C106.71 167.546 112.538 157.781 124.193 146.767Z"
            fill="white"
          />
          <path
            opacity="0.2"
            d="M139.484 267.126V242.458L122.159 219.829C121.986 219.603 122.029 219.279 122.255 219.106C122.482 218.933 122.805 218.976 122.978 219.202L140.409 241.97C140.478 242.06 140.516 242.17 140.516 242.283V265.779L156.792 244.52C156.965 244.294 157.289 244.251 157.515 244.424C157.741 244.597 157.784 244.921 157.611 245.147L140.516 267.476V269.795C140.516 269.974 140.425 270.132 140.286 270.224V292.088L140.409 292.249C140.478 292.339 140.516 292.449 140.516 292.562V310.901L156.792 289.642C156.965 289.416 157.289 289.373 157.515 289.546C157.741 289.719 157.784 290.043 157.611 290.269L140.516 312.598V320.074C140.516 320.253 140.425 320.411 140.286 320.503V333.685C140.336 333.766 140.363 333.859 140.363 333.955V374.46C140.363 374.745 140.132 374.975 139.847 374.975C139.562 374.975 139.331 374.745 139.331 374.46V340.505C139.283 340.427 139.255 340.334 139.255 340.235V334.087L121.146 315.517C120.948 315.313 120.952 314.986 121.156 314.787C121.36 314.588 121.686 314.593 121.885 314.796L139.255 332.61V312.723C139.255 312.61 139.292 312.5 139.361 312.41L139.484 312.249V295.542C139.346 295.449 139.255 295.292 139.255 295.113V292.438L122.159 270.109C121.986 269.882 122.029 269.559 122.255 269.386C122.482 269.212 122.805 269.255 122.978 269.482L139.255 290.741V267.601C139.255 267.487 139.292 267.377 139.361 267.287L139.484 267.126Z"
            fill="white"
          />
          <path
            opacity="0.6"
            d="M406.926 385.084C403.401 380.062 398.24 377.552 391.442 377.552C381.246 377.552 386.161 369.646 375.587 369.646C368.703 369.646 368.703 374.046 358.844 371.313C348.679 368.495 358.844 360.514 339.584 359.58C320.324 358.647 325.126 371.313 317.195 371.313C311.484 371.313 311.116 366.504 306.244 366.114C301.371 365.723 300.705 368.913 297.054 368.513C292.606 368.026 294.285 363.98 283.44 363.98C272.595 363.98 276.283 371.796 273.64 372.654C270.996 373.513 267.597 370.646 263.947 374.046C260.296 377.446 266.62 379.045 261.303 379.045C254.824 379.045 251.25 381.058 250.578 385.084C251.055 386.316 255.511 387.006 263.947 387.152C276.599 387.372 277.169 385.482 292.868 385.819C308.567 386.156 313.752 390.619 336.298 390.619C358.844 390.619 352.318 388.5 369.531 387.686C386.744 386.871 399.935 388.555 409.814 388.219C415.226 388.035 414.263 386.99 406.926 385.084Z"
            fill="#45F882"
          />
          <path
            d="M465.323 388.588C461.798 383.567 456.637 381.056 449.839 381.056C439.642 381.056 443.545 384.122 432.97 384.122C422.396 384.122 428.75 367.244 403.04 366.351C377.33 365.458 383.15 376.175 375.219 376.175C367.289 376.175 363.024 370.924 353.316 371.295C343.607 371.666 339.69 383.456 335.788 384.122C331.886 384.789 334.781 381.789 324.081 381.789C316.947 381.789 311.912 384.056 308.975 388.588C304.882 391.05 309.13 392.281 321.719 392.281C326.353 392.281 339.118 391.082 353.316 390.748C361.328 390.56 375.956 394.147 394.354 394.147C403.04 394.147 410.483 392.545 427.461 392.281C444.439 392.017 462.182 393.016 471.772 392.281C478.361 391.776 476.211 390.545 465.323 388.588Z"
            fill="#37CE6F"
          />
          <path
            opacity="0.6"
            d="M212.643 380.169C209.118 375.148 203.957 372.637 197.159 372.637C186.963 372.637 190.865 375.703 180.291 375.703C169.716 375.703 176.07 358.825 150.36 357.932C124.65 357.039 130.47 367.757 122.54 367.757C114.609 367.757 110.345 362.505 100.636 362.876C90.9271 363.247 87.0107 375.037 83.1083 375.703C79.2059 376.37 82.1013 373.37 71.4011 373.37C64.2677 373.37 59.2324 375.637 56.2951 380.169C52.2027 382.631 56.4507 383.862 69.0391 383.862C73.6736 383.862 86.4381 382.663 100.636 382.329C108.648 382.141 123.276 385.728 141.674 385.728C150.36 385.728 157.803 384.126 174.782 383.862C191.76 383.598 209.502 384.597 219.093 383.862C225.681 383.357 223.531 382.126 212.643 380.169Z"
            fill="#45F882"
          />
          <path
            d="M18.8751 421.112C29.2995 421.112 37.7502 420.597 37.7502 419.961C37.7502 419.326 29.2995 418.811 18.8751 418.811C8.45067 418.811 0 419.326 0 419.961C0 420.597 8.45067 421.112 18.8751 421.112Z"
            fill="#8FD8FC"
          />
          <path
            d="M551.039 430.059C561.464 430.059 569.914 429.544 569.914 428.909C569.914 428.273 561.464 427.758 551.039 427.758C540.615 427.758 532.164 428.273 532.164 428.909C532.164 429.544 540.615 430.059 551.039 430.059Z"
            fill="#8FD8FC"
          />
          <path
            d="M27.3344 410.461C27.8458 411.422 29.0599 411.777 30.0463 411.253C31.0326 410.728 35.8414 407.171 35.33 406.209C34.8186 405.248 29.1807 407.245 28.1943 407.77C27.208 408.294 26.823 409.499 27.3344 410.461ZM28.3336 404.245C28.845 405.207 30.0592 405.562 31.0455 405.037C32.0319 404.513 36.8406 400.956 36.3292 399.994C35.8178 399.032 30.1799 401.03 29.1936 401.554C28.2072 402.079 27.8222 403.283 28.3336 404.245ZM28.6869 398.436C29.3425 399.306 30.5971 399.467 31.4893 398.794C32.3814 398.122 36.5746 393.857 35.919 392.987C35.2635 392.117 30.0074 394.972 29.1153 395.644C28.2231 396.316 28.0313 397.566 28.6869 398.436ZM29.1748 392.415C29.9451 393.185 31.2098 393.17 31.9997 392.38C32.7896 391.59 36.3483 386.782 35.5781 386.012C34.8078 385.242 30.0003 388.8 29.2104 389.59C28.4205 390.38 28.4045 391.645 29.1748 392.415ZM28.6166 386.285C29.4511 386.985 30.7097 386.859 31.4277 386.004C32.1458 385.148 35.2719 380.048 34.4375 379.348C33.603 378.648 29.1239 382.612 28.4059 383.468C27.6878 384.324 27.7822 385.585 28.6166 386.285ZM28.1083 380.377C29.061 380.905 30.2724 380.541 30.814 379.564C31.3556 378.587 33.4513 372.985 32.4986 372.456C31.5458 371.928 27.9054 376.674 27.3639 377.651C26.8223 378.628 27.1556 379.849 28.1083 380.377ZM26.8228 374.979C27.8798 375.243 28.9557 374.578 29.2259 373.494C29.4962 372.41 30.0705 366.456 29.0135 366.193C27.9566 365.929 25.6686 371.455 25.3983 372.539C25.1281 373.623 25.7658 374.716 26.8228 374.979ZM24.0096 369.58C25.0988 369.599 25.9975 368.709 26.017 367.592C26.0365 366.475 25.2568 360.545 24.1677 360.526C23.0785 360.507 22.0923 366.406 22.0728 367.523C22.0533 368.64 22.9205 369.561 24.0096 369.58ZM21.1212 370.037C21.515 369.296 21.2185 368.369 20.4591 367.965C19.6996 367.561 15.3585 366.023 14.9647 366.764C14.5709 367.504 18.2736 370.243 19.0331 370.647C19.7926 371.051 20.7274 370.778 21.1212 370.037ZM23.7597 375.661C24.2287 374.966 24.0309 374.012 23.3178 373.531C22.6047 373.05 18.4481 371.066 17.9791 371.762C17.5101 372.457 20.9062 375.568 21.6193 376.049C22.3324 376.53 23.2907 376.356 23.7597 375.661ZM25.6493 381.193C26.1061 380.49 25.8916 379.54 25.1702 379.072C24.4489 378.603 20.2583 376.692 19.8015 377.396C19.3447 378.099 22.7946 381.15 23.516 381.619C24.2373 382.087 25.1925 381.897 25.6493 381.193ZM27.0181 387.446C27.5459 386.794 27.4319 385.827 26.7635 385.286C26.095 384.744 22.1271 382.406 21.5993 383.058C21.0715 383.71 24.1835 387.105 24.852 387.646C25.5204 388.187 26.4902 388.098 27.0181 387.446ZM27.0631 393.178C27.5561 392.499 27.3917 391.539 26.6958 391.034C25.9999 390.528 21.9151 388.401 21.4221 389.079C20.9291 389.758 24.2146 392.986 24.9104 393.491C25.6063 393.997 26.5701 393.856 27.0631 393.178ZM26.9113 397.957C27.279 397.203 26.9503 396.286 26.1772 395.909C25.4041 395.532 21.012 394.147 20.6443 394.9C20.2766 395.654 24.0726 398.262 24.8457 398.639C25.6188 399.016 26.5436 398.711 26.9113 397.957ZM26.3326 402.606C26.6331 401.822 26.2258 400.938 25.4228 400.63C24.6198 400.321 20.1236 399.324 19.823 400.107C19.5224 400.89 23.5313 403.157 24.3343 403.465C25.1373 403.773 26.032 403.389 26.3326 402.606ZM25.7265 408.745C26.1332 408.011 25.853 407.079 25.1007 406.662C24.3483 406.245 20.0347 404.631 19.6281 405.365C19.2215 406.098 22.8758 408.901 23.6281 409.318C24.3804 409.735 25.3199 409.479 25.7265 408.745Z"
            fill="#8FD8FC"
          />
          <path
            d="M23.6748 418.981C23.6051 419.257 23.7724 419.537 24.0486 419.607C24.3247 419.677 24.6051 419.509 24.6749 419.233C30.4284 396.449 29.6185 379.578 22.1922 368.629C22.0323 368.393 21.7117 368.332 21.4759 368.492C21.2402 368.652 21.1788 368.972 21.3386 369.208C28.5671 379.865 29.3634 396.454 23.6748 418.981Z"
            fill="#465197"
          />
          <path
            d="M25.5579 408.821C26.3615 409.545 27.6188 409.458 28.3663 408.628C29.1138 407.798 32.4208 402.815 31.6173 402.091C30.8137 401.368 26.2038 405.178 25.4563 406.008C24.7088 406.838 24.7543 408.098 25.5579 408.821ZM24.9005 402.819C25.7969 403.423 27.0301 403.163 27.6547 402.236C28.2794 401.31 30.8608 395.916 29.9643 395.311C29.0678 394.706 25.033 399.121 24.4083 400.047C23.7837 400.973 24.004 402.214 24.9005 402.819ZM23.2017 396.909C24.1475 397.434 25.3532 397.067 25.8948 396.089C26.4364 395.112 28.5377 389.513 27.592 388.989C26.6462 388.465 23.0115 393.214 22.4699 394.191C21.9283 395.168 22.256 396.385 23.2017 396.909ZM21.5968 391.208C22.6252 391.542 23.7387 390.952 24.0839 389.89C24.4292 388.827 25.4235 382.93 24.3951 382.596C23.3667 382.262 20.705 387.617 20.3598 388.679C20.0145 389.742 20.5684 390.874 21.5968 391.208ZM19.4918 385.249C20.569 385.154 21.3633 384.176 21.266 383.063C21.1686 381.95 19.7797 376.133 18.7025 376.228C17.6253 376.322 17.2676 382.292 17.365 383.404C17.4624 384.517 18.4146 385.343 19.4918 385.249ZM15.4417 380.255C16.4136 379.781 16.8045 378.583 16.3148 377.579C15.8251 376.575 12.4439 371.642 11.472 372.116C10.5001 372.59 12.3056 378.291 12.7953 379.295C13.285 380.299 14.4698 380.729 15.4417 380.255ZM12.4439 381.924C12.5454 381.098 11.9356 380.343 11.0818 380.238C10.2281 380.133 5.62469 380.248 5.52322 381.074C5.42175 381.901 9.86062 383.126 10.7144 383.23C11.5681 383.335 12.3425 382.75 12.4439 381.924ZM16.4999 387.415C16.8252 386.649 16.4471 385.755 15.6553 385.419C14.8636 385.083 10.4068 383.924 10.0815 384.691C9.7562 385.457 13.6854 387.858 14.4772 388.194C15.269 388.53 16.1746 388.182 16.4999 387.415ZM19.3862 392.483C19.6981 391.711 19.3044 390.824 18.5069 390.502C17.7094 390.18 13.2331 389.099 12.9212 389.871C12.6093 390.643 16.5799 392.976 17.3774 393.298C18.1749 393.62 19.0743 393.255 19.3862 392.483ZM21.8998 398.358C22.2906 397.623 21.9918 396.699 21.2324 396.295C20.4729 395.892 16.1341 394.349 15.7433 395.084C15.3524 395.819 19.0574 398.554 19.8169 398.958C20.5763 399.361 21.5089 399.093 21.8998 398.358ZM23.0263 403.975C23.3782 403.22 23.0315 402.314 22.2519 401.95C21.4724 401.587 17.0588 400.273 16.7069 401.028C16.3551 401.783 20.1981 404.319 20.9777 404.683C21.7572 405.046 22.6744 404.729 23.0263 403.975ZM23.7818 408.694C23.9973 407.89 23.4985 407.058 22.6676 406.835C21.8368 406.613 17.2622 406.086 17.0467 406.89C16.8312 407.694 21.0564 409.525 21.8872 409.748C22.7181 409.97 23.5663 409.499 23.7818 408.694Z"
            fill="#BFEAFF"
          />
          <path
            d="M23.6587 419.673C23.626 419.955 23.8288 420.211 24.1117 420.244C24.3947 420.277 24.6506 420.074 24.6833 419.791C26.6097 403.141 22.9297 390.132 13.6289 380.812C13.4277 380.61 13.1012 380.61 12.8996 380.811C12.698 381.013 12.6976 381.339 12.8988 381.541C21.9598 390.62 25.5512 403.316 23.6587 419.673Z"
            fill="#465197"
          />
          <path
            d="M554.483 417.68C554.994 418.642 556.208 418.997 557.195 418.472C558.181 417.948 562.99 414.391 562.478 413.429C561.967 412.467 556.329 414.465 555.343 414.989C554.356 415.514 553.971 416.719 554.483 417.68ZM555.482 411.465C555.993 412.427 557.208 412.781 558.194 412.257C559.18 411.732 563.989 408.175 563.478 407.214C562.966 406.252 557.328 408.249 556.342 408.774C555.356 409.298 554.971 410.503 555.482 411.465ZM555.835 405.656C556.491 406.526 557.746 406.686 558.638 406.014C559.53 405.342 563.723 401.076 563.067 400.206C562.412 399.336 557.156 402.191 556.264 402.864C555.372 403.536 555.18 404.786 555.835 405.656ZM556.323 399.635C557.093 400.405 558.358 400.389 559.148 399.599C559.938 398.809 563.497 394.002 562.727 393.232C561.956 392.461 557.149 396.02 556.359 396.81C555.569 397.6 555.553 398.865 556.323 399.635ZM555.765 393.505C556.6 394.205 557.858 394.079 558.576 393.223C559.294 392.368 562.42 387.268 561.586 386.568C560.751 385.868 556.272 389.832 555.554 390.688C554.836 391.543 554.931 392.805 555.765 393.505ZM555.257 387.596C556.209 388.124 557.421 387.761 557.962 386.784C558.504 385.806 560.6 380.204 559.647 379.676C558.694 379.148 555.054 383.894 554.512 384.871C553.971 385.848 554.304 387.068 555.257 387.596ZM553.971 382.199C555.028 382.462 556.104 381.797 556.374 380.713C556.645 379.63 557.219 373.676 556.162 373.412C555.105 373.149 552.817 378.675 552.547 379.759C552.277 380.843 552.914 381.935 553.971 382.199ZM551.158 376.8C552.247 376.819 553.146 375.929 553.165 374.812C553.185 373.695 552.405 367.765 551.316 367.746C550.227 367.727 549.241 373.626 549.221 374.743C549.202 375.86 550.069 376.781 551.158 376.8ZM548.27 377.257C548.663 376.516 548.367 375.588 547.608 375.185C546.848 374.781 542.507 373.243 542.113 373.983C541.719 374.724 545.422 377.463 546.182 377.867C546.941 378.27 547.876 377.997 548.27 377.257ZM550.908 382.881C551.377 382.185 551.179 381.232 550.466 380.751C549.753 380.27 545.597 378.286 545.128 378.982C544.659 379.677 548.055 382.788 548.768 383.269C549.481 383.75 550.439 383.576 550.908 382.881ZM552.798 388.413C553.255 387.71 553.04 386.76 552.319 386.291C551.597 385.823 547.407 383.912 546.95 384.616C546.493 385.319 549.943 388.37 550.664 388.839C551.386 389.307 552.341 389.117 552.798 388.413ZM554.167 394.666C554.694 394.014 554.58 393.047 553.912 392.505C553.243 391.964 549.276 389.626 548.748 390.278C548.22 390.929 551.332 394.324 552 394.866C552.669 395.407 553.639 395.317 554.167 394.666ZM554.212 400.398C554.705 399.719 554.54 398.759 553.844 398.254C553.148 397.748 549.064 395.621 548.571 396.299C548.078 396.978 551.363 400.205 552.059 400.711C552.755 401.216 553.719 401.076 554.212 400.398ZM554.06 405.177C554.427 404.423 554.099 403.506 553.326 403.129C552.553 402.752 548.16 401.366 547.793 402.12C547.425 402.874 551.221 405.482 551.994 405.859C552.767 406.236 553.692 405.931 554.06 405.177ZM553.481 409.825C553.782 409.042 553.374 408.158 552.571 407.849C551.768 407.541 547.272 406.543 546.971 407.326C546.671 408.11 550.68 410.377 551.483 410.685C552.286 410.993 553.18 410.608 553.481 409.825ZM552.875 415.965C553.282 415.231 553.001 414.298 552.249 413.881C551.497 413.464 547.183 411.851 546.777 412.584C546.37 413.318 550.024 416.121 550.777 416.538C551.529 416.955 552.468 416.698 552.875 415.965Z"
            fill="#8FD8FC"
          />
          <path
            d="M550.831 426.201C550.761 426.477 550.929 426.757 551.205 426.827C551.481 426.897 551.761 426.729 551.831 426.453C557.585 403.668 556.775 386.798 549.348 375.849C549.189 375.613 548.868 375.552 548.632 375.712C548.396 375.871 548.335 376.192 548.495 376.428C555.723 387.085 556.52 403.673 550.831 426.201Z"
            fill="#465197"
          />
          <path
            d="M552.706 416.041C553.51 416.764 554.767 416.678 555.515 415.848C556.262 415.018 559.569 410.035 558.766 409.311C557.962 408.588 553.352 412.397 552.605 413.228C551.857 414.058 551.903 415.317 552.706 416.041ZM552.049 410.038C552.945 410.643 554.178 410.382 554.803 409.456C555.428 408.53 558.009 403.135 557.113 402.531C556.216 401.926 552.181 406.34 551.557 407.266C550.932 408.193 551.152 409.434 552.049 410.038ZM550.35 404.129C551.296 404.653 552.502 404.286 553.043 403.309C553.585 402.332 555.686 396.733 554.74 396.209C553.795 395.685 550.16 400.434 549.618 401.411C549.077 402.388 549.404 403.605 550.35 404.129ZM548.745 398.428C549.774 398.762 550.887 398.172 551.232 397.109C551.578 396.047 552.572 390.15 551.544 389.816C550.515 389.481 547.853 394.837 547.508 395.899C547.163 396.962 547.717 398.094 548.745 398.428ZM546.64 392.468C547.717 392.374 548.512 391.396 548.414 390.283C548.317 389.17 546.928 383.353 545.851 383.447C544.774 383.542 544.416 389.511 544.513 390.624C544.611 391.737 545.563 392.563 546.64 392.468ZM542.59 387.475C543.562 387.001 543.953 385.803 543.463 384.799C542.974 383.795 539.592 378.862 538.62 379.336C537.649 379.81 539.454 385.511 539.944 386.515C540.433 387.519 541.618 387.949 542.59 387.475ZM539.592 389.144C539.694 388.317 539.084 387.562 538.23 387.457C537.377 387.353 532.773 387.467 532.672 388.294C532.57 389.12 537.009 390.345 537.863 390.45C538.717 390.555 539.491 389.97 539.592 389.144ZM543.648 394.635C543.974 393.868 543.596 392.975 542.804 392.639C542.012 392.302 537.555 391.144 537.23 391.91C536.905 392.677 540.834 395.078 541.626 395.414C542.417 395.75 543.323 395.401 543.648 394.635ZM546.535 399.703C546.847 398.931 546.453 398.044 545.655 397.722C544.858 397.4 540.382 396.319 540.07 397.091C539.758 397.863 543.728 400.195 544.526 400.517C545.323 400.84 546.223 400.475 546.535 399.703ZM549.048 405.577C549.439 404.842 549.14 403.919 548.381 403.515C547.621 403.111 543.283 401.569 542.892 402.304C542.501 403.039 546.206 405.774 546.965 406.177C547.725 406.581 548.657 406.313 549.048 405.577ZM550.175 411.195C550.527 410.44 550.18 409.534 549.4 409.17C548.621 408.806 544.207 407.493 543.855 408.248C543.503 409.002 547.347 411.539 548.126 411.903C548.906 412.266 549.823 411.949 550.175 411.195ZM550.93 415.914C551.146 415.11 550.647 414.277 549.816 414.055C548.985 413.832 544.411 413.305 544.195 414.11C543.98 414.914 548.205 416.745 549.036 416.967C549.867 417.19 550.715 416.718 550.93 415.914Z"
            fill="#BFEAFF"
          />
          <path
            d="M550.807 426.893C550.774 427.176 550.977 427.432 551.26 427.464C551.543 427.497 551.799 427.294 551.832 427.011C553.758 410.361 550.078 397.352 540.777 388.032C540.576 387.831 540.25 387.83 540.048 388.032C539.846 388.233 539.846 388.559 540.047 388.761C549.108 397.841 552.7 410.536 550.807 426.893Z"
            fill="#465197"
          />
          <path
            opacity="0.16"
            d="M54.351 259.454C55.8489 250.457 63.4899 243.608 72.6907 243.608C82.9665 243.608 91.2967 252.151 91.2967 262.689C91.2967 269.085 88.2275 274.746 83.5169 278.208C85.3561 282.304 86.3819 286.864 86.3819 291.669C86.3819 293.176 86.1827 294.8 85.7844 296.542C83.1161 308.212 84.5907 320.447 89.9554 331.148C92.7219 336.667 94.1051 341.688 94.1051 346.211C94.1051 368.48 76.5018 386.532 54.7869 386.532C33.0721 386.532 15.4688 368.48 15.4688 346.211C15.4688 341.623 16.8901 336.533 19.7327 330.941C25.1536 320.278 26.699 308.062 24.1044 296.385C23.7301 294.7 23.543 293.129 23.543 291.669C23.543 274.084 37.2807 259.789 54.351 259.454Z"
            fill="white"
          />
          <path
            opacity="0.6"
            d="M54.9503 362.358V375.54C54.9998 375.621 55.0266 375.714 55.0266 375.81V416.315C55.0266 416.599 54.7957 416.83 54.5109 416.83C54.2261 416.83 53.9952 416.599 53.9952 416.315V382.36C53.9468 382.282 53.9189 382.189 53.9189 382.09V375.942L35.8105 357.371C35.6117 357.168 35.6158 356.841 35.8197 356.642C36.0236 356.443 36.3501 356.447 36.549 356.651L53.9189 374.464V354.578C53.9189 354.465 53.9563 354.354 54.0252 354.264L54.1484 354.104V334.592L36.8235 311.964C36.6503 311.737 36.6933 311.414 36.9195 311.241C37.1456 311.067 37.4693 311.11 37.6424 311.337L55.0735 334.104C55.1424 334.194 55.1798 334.304 55.1798 334.417V352.756L71.4563 331.497C71.6294 331.271 71.9531 331.228 72.1792 331.401C72.4054 331.574 72.4484 331.898 72.2752 332.124L55.1798 354.453V361.929C55.1798 362.108 55.0887 362.266 54.9503 362.358Z"
            fill="white"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M340.515 392.812C346.665 399.083 349.643 402.425 349.45 402.839C349.16 403.46 343.142 405.667 340.222 403.98C337.302 402.293 336.552 396.446 335.899 395.008C335.247 393.569 332.918 392.483 330.899 391.542C328.881 390.601 328.683 388.997 329.045 388.22C329.407 387.444 330.784 387.33 333.941 387.857C336.046 388.208 338.237 389.86 340.515 392.812Z"
            fill="#EC961F"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M366.942 409.106C368.015 412.168 368.988 414.016 369.863 414.649C371.635 415.929 373.758 417.8 375.377 418.027C376.909 418.243 378.969 418.646 379.539 419.914C379.789 420.47 379.622 421.653 379.507 421.993C376.419 421.735 375.058 421.544 373.415 420.876C371.455 420.08 366.445 418.595 366.445 418.595C364.031 416.534 362.403 415.055 361.561 414.158C360.719 413.262 362.513 411.577 366.942 409.106Z"
            fill="#EC961F"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M384.298 391.79C388.673 397.941 390.195 402.373 388.864 405.089C386.867 409.162 381.173 412.164 378.505 410.154C375.836 408.143 375.333 403.687 377.91 400.267C380.488 396.846 380.544 396.255 381.489 393.525C382.119 391.704 383.056 391.126 384.298 391.79Z"
            fill="#EC961F"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M342.903 384.626C342.923 381.754 332.396 378.782 332.065 377.871C331.733 376.96 340.593 378.634 343.337 380.859C346.08 383.083 362.097 399.815 369.474 392.102C376.852 384.389 384.152 390.439 387.963 395.241C389.785 397.414 387.946 399.959 388.803 400.736C389.66 401.514 392.406 406.387 392.893 407.37C393.38 408.353 389.251 411.532 387.636 411.346C383.922 410.918 379.001 406.941 376.227 406.404C373.453 405.866 367.565 412.005 366.065 413.196C365.065 413.99 363.388 414.342 361.035 414.253C360.3 415.339 359.961 415.965 360.021 416.13C360.482 417.416 361.6 418.968 363.376 420.785C365.135 421.605 365.633 422.971 364.867 424.883C363.128 424.828 361.431 424.415 359.775 423.642C357.29 422.484 357.725 421.552 357.787 421.014C357.819 420.729 356.017 420.161 354.842 415.923C354.638 415.185 354.701 413.381 355.031 410.508C354.255 410.146 348.912 405.387 348.415 404.021C347.918 402.655 343.322 399.944 342.618 399.427C341.914 398.91 341.458 399.075 340.248 399.645C339.037 400.215 335.88 399.688 334.969 400.019C334.058 400.351 332.145 403.239 332.145 403.239C332.145 403.239 329.33 404.232 329.222 405C329.038 406.307 330.259 408.388 327.292 408.145C324.678 407.93 325.417 403.883 325.996 402.641C326.576 401.398 328.118 401.739 331.955 393.51C335.793 385.28 339.645 385.754 342.903 384.626Z"
            fill="#F5C16A"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M363.062 422.191C364.098 422.674 364.374 423.433 363.891 424.468L363.062 422.191Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M367.32 394.523C371.738 402.885 374.151 407.034 374.558 406.972C375.169 406.879 373.607 408.608 372.83 408.246C372.054 407.884 363.522 395.777 364.463 393.758L367.206 393.146L367.32 394.523Z"
            fill="#F05E36"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M364.281 422.004C365.061 422.494 365.186 423.308 364.655 424.447L364.281 422.004Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M380.536 388.943C381.706 389.728 381.635 390.826 380.323 392.237C378.356 394.354 377.861 394.68 376.051 398.562C374.241 402.444 370.07 404.091 367.042 402.679C364.014 401.267 363.992 394.829 366.651 391.154C368.423 388.704 373.052 387.967 380.536 388.943Z"
            fill="#EC961F"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M388.831 405.666C389.53 405.132 392.341 406.665 392.534 407.393C392.728 408.121 391.048 408.968 390.554 408.738C389.814 408.393 388.131 406.199 388.831 405.666Z"
            fill="#1C2229"
          />
          <path
            d="M382.869 408.131C382.871 407.303 382.734 406.768 382.458 406.525C380.93 405.182 379.164 404.874 379.164 404.874C379.164 404.874 380.916 403.895 382.891 405.203C384.208 406.076 384.2 407.052 382.869 408.131Z"
            fill="#DF4C32"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M355.031 410.32C355.466 409.389 355.624 408.643 355.507 408.084L355.031 410.32Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M361.492 413.9C363.672 411.388 364.844 409.414 365.009 407.979L361.492 413.9Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M341.844 398.877C343.338 397.683 344.241 396.277 344.555 394.659L341.844 398.877Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M373.836 402.832C374.381 404.094 375.016 404.894 375.741 405.232L373.836 402.832Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M327.565 405.641C327.88 406.739 327.489 407.445 326.391 407.76L327.565 405.641Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M328.807 405.833C329.122 406.93 328.731 407.637 327.633 407.952L328.807 405.833Z"
            stroke="#ED8B38"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M264.425 189.922C261.334 193.868 256.774 199.603 253.271 192.401C249.768 185.2 258.635 151.667 255.561 141.85C254.997 138.396 259.907 136.096 261.614 140.518C261.997 145.917 261.48 163.895 264.567 170.954C269.135 181.402 266.171 187.692 264.425 189.922Z"
            fill="#FFAA83"
          />
          <path
            d="M262.685 136.47C265.309 137.724 265.179 141.217 262.216 144.452C261.467 145.269 260.645 142.69 259.045 142.302C258.061 142.063 256.475 144.302 255.343 143.782C251.03 141.799 246.124 138.249 244.286 136.793C241.182 134.334 241.125 133.207 243.462 132.164C245.8 131.121 260.06 135.216 262.685 136.47Z"
            fill="#445A65"
          />
          <path
            d="M252.606 140.564C252.741 140.313 253.054 140.22 253.304 140.355C253.555 140.49 253.648 140.803 253.513 141.054L252.407 143.101C252.272 143.352 251.959 143.445 251.708 143.31C251.458 143.175 251.364 142.862 251.5 142.611L252.606 140.564Z"
            fill="white"
          />
          <path
            d="M250.113 139.19C250.249 138.939 250.562 138.846 250.812 138.981C251.063 139.116 251.156 139.429 251.021 139.68L249.915 141.727C249.779 141.978 249.467 142.071 249.216 141.936C248.965 141.801 248.872 141.488 249.007 141.237L250.113 139.19Z"
            fill="white"
          />
          <path
            d="M251.301 139.828C251.436 139.578 251.749 139.484 252 139.62C252.25 139.755 252.344 140.068 252.208 140.319L251.102 142.366C250.967 142.617 250.654 142.71 250.404 142.575C250.153 142.439 250.06 142.126 250.195 141.876L251.301 139.828Z"
            fill="white"
          />
          <path
            d="M261.691 136.373C261.844 136.133 262.163 136.063 262.403 136.216C262.643 136.369 262.714 136.688 262.56 136.928C261.511 138.573 261.849 139.871 263.665 141.052C263.904 141.208 263.971 141.527 263.816 141.766C263.661 142.005 263.341 142.072 263.102 141.917C260.827 140.436 260.326 138.512 261.691 136.373Z"
            fill="white"
          />
          <path
            d="M247.593 133.052C247.634 132.77 247.896 132.575 248.178 132.616C248.459 132.657 248.655 132.919 248.614 133.2C248.183 136.155 246.806 137.54 244.58 137.066C244.302 137.007 244.124 136.733 244.183 136.455C244.243 136.176 244.517 135.998 244.795 136.058C246.34 136.387 247.239 135.482 247.593 133.052Z"
            fill="white"
          />
          <path
            d="M246.494 136.778C246.247 136.637 246.161 136.322 246.302 136.074C246.444 135.827 246.759 135.741 247.006 135.883C250.923 138.122 253.582 139.259 254.891 139.291C255.543 139.307 256.156 139.094 257.423 138.486C257.484 138.458 257.484 138.458 257.544 138.429C259.46 137.51 260.351 137.273 261.46 137.736C261.723 137.845 261.847 138.147 261.737 138.41C261.628 138.673 261.326 138.797 261.063 138.688C260.335 138.384 259.632 138.571 257.99 139.358C257.93 139.387 257.93 139.387 257.869 139.417C256.453 140.096 255.74 140.344 254.866 140.323C253.323 140.285 250.564 139.104 246.494 136.778Z"
            fill="white"
          />
          <path
            d="M256.314 143.111C256.249 143.151 257.041 142.646 257.292 142.495C258.009 142.065 258.546 141.824 259.012 141.792C259.884 141.732 260.9 142.542 262.208 144.184C262.385 144.407 262.348 144.731 262.126 144.909C261.903 145.086 261.578 145.049 261.401 144.827C260.304 143.45 259.482 142.794 259.082 142.821C258.834 142.838 258.402 143.032 257.823 143.379C257.586 143.521 256.807 144.019 256.861 143.985C256.34 144.311 256.208 144.378 255.933 144.32L255.033 144.128C254.755 144.069 254.577 143.795 254.636 143.516C254.696 143.238 254.97 143.06 255.248 143.119L256.021 143.284C256.089 143.248 256.184 143.192 256.314 143.111Z"
            fill="white"
          />
          <path
            d="M285.988 189.494C282.502 193.096 277.367 198.322 274.636 190.794C271.905 183.266 284.935 150.35 282.905 140.265C282.704 136.771 287.444 136.104 288.68 140.68C288.497 146.09 285.779 163.301 288.111 170.645C291.563 181.513 287.958 187.458 285.988 189.494Z"
            fill="#FFAA83"
          />
          <path
            d="M293.116 138.482C294.676 140.937 292.715 143.83 288.488 145.003C287.42 145.299 288.09 142.676 286.939 141.5C286.231 140.776 283.699 141.834 283.015 140.793C280.408 136.825 278.128 131.215 277.341 129.007C276.012 125.276 276.561 124.29 279.096 124.644C281.631 124.998 291.555 136.028 293.116 138.482Z"
            fill="#445A65"
          />
          <path
            d="M282.401 136.613C282.649 136.472 282.964 136.559 283.104 136.806C283.245 137.054 283.159 137.369 282.911 137.51L280.888 138.66C280.64 138.801 280.325 138.714 280.185 138.466C280.044 138.219 280.13 137.904 280.378 137.763L282.401 136.613Z"
            fill="white"
          />
          <path
            d="M281.01 134.125C281.258 133.984 281.573 134.07 281.714 134.318C281.854 134.566 281.768 134.88 281.52 135.021L279.497 136.172C279.25 136.312 278.935 136.226 278.794 135.978C278.653 135.731 278.74 135.416 278.987 135.275L281.01 134.125Z"
            fill="white"
          />
          <path
            d="M281.682 135.299C281.93 135.158 282.245 135.245 282.386 135.492C282.526 135.74 282.44 136.055 282.192 136.196L280.169 137.346C279.922 137.487 279.607 137.4 279.466 137.152C279.325 136.905 279.412 136.59 279.659 136.449L281.682 135.299Z"
            fill="white"
          />
          <path
            d="M292.323 137.874C292.58 137.752 292.888 137.861 293.011 138.118C293.133 138.375 293.024 138.683 292.767 138.805C291.005 139.644 290.603 140.924 291.518 142.888C291.638 143.146 291.526 143.453 291.268 143.573C291.009 143.693 290.703 143.581 290.582 143.323C289.437 140.862 290.032 138.964 292.323 137.874Z"
            fill="white"
          />
          <path
            d="M282.129 127.583C282.313 127.366 282.638 127.339 282.856 127.523C283.073 127.707 283.1 128.033 282.916 128.25C280.985 130.527 279.083 130.973 277.446 129.391C277.242 129.193 277.236 128.867 277.434 128.662C277.632 128.457 277.958 128.452 278.163 128.65C279.299 129.747 280.541 129.456 282.129 127.583Z"
            fill="white"
          />
          <path
            d="M279.218 130.162C279.083 129.911 279.177 129.598 279.428 129.463C279.679 129.329 279.992 129.423 280.126 129.674C282.261 133.648 283.914 136.022 285.007 136.743C285.551 137.102 286.185 137.246 287.581 137.402C287.647 137.41 287.647 137.41 287.714 137.417C289.825 137.653 290.706 137.925 291.402 138.904C291.567 139.137 291.512 139.459 291.28 139.623C291.047 139.788 290.726 139.734 290.561 139.501C290.105 138.859 289.409 138.644 287.599 138.442C287.533 138.435 287.533 138.435 287.466 138.427C285.905 138.252 285.169 138.085 284.439 137.604C283.151 136.754 281.436 134.291 279.218 130.162Z"
            fill="white"
          />
          <path
            d="M284.188 140.737C284.112 140.737 285.051 140.728 285.345 140.733C286.18 140.748 286.763 140.829 287.175 141.049C287.947 141.46 288.379 142.686 288.618 144.771C288.651 145.054 288.447 145.309 288.164 145.342C287.881 145.374 287.626 145.171 287.593 144.888C287.393 143.139 287.043 142.147 286.69 141.959C286.47 141.841 286.001 141.777 285.326 141.764C285.05 141.759 284.126 141.769 284.189 141.769C283.575 141.769 283.427 141.756 283.225 141.56L282.564 140.921C282.359 140.723 282.353 140.397 282.551 140.192C282.749 139.987 283.076 139.982 283.28 140.18L283.849 140.729C283.925 140.735 284.035 140.737 284.188 140.737Z"
            fill="white"
          />
          <path
            d="M272.022 184.911C272.595 176.579 274.566 156.419 280.949 150.828C281.372 150.457 281.085 149.447 281.117 148.776C280.917 145.282 287.032 144.549 288.268 149.126C288.252 149.614 287.746 151.031 288.274 151.265C295.109 154.287 290.329 189.468 290.473 189.855C294.248 199.979 293.697 214.879 292.075 225.527C290.786 233.993 286.915 240.892 284.119 241.966C278.126 244.267 265.268 245.766 261.333 240.904C260.083 239.36 255.943 240.551 256.402 238.094C255.878 237.234 256.052 234.16 255.616 232.988C252.175 223.76 248.734 189.58 248.896 187.917C249.926 177.373 248.4 154.694 254.563 149.655C255.051 149.256 254.77 148.107 254.853 147.417C255.137 144.164 261.245 144.022 262.115 146.621C262.15 147.227 261.888 148.413 262.334 148.607C269.552 151.747 268.176 169.402 266.725 183.491C267.289 184.544 267.575 188.278 268.122 189.744C269.592 193.686 270.471 201.15 272.047 206.455C271.889 202.424 271.881 195.243 272.022 184.911Z"
            fill="#45F882"
          />
          <path
            d="M261.714 148.352C261.967 148.483 262.067 148.794 261.936 149.047C261.806 149.3 261.495 149.399 261.242 149.269C259.607 148.427 258.081 148.686 256.552 150.088C256.342 150.28 256.016 150.266 255.823 150.056C255.631 149.846 255.645 149.52 255.855 149.328C257.692 147.643 259.682 147.305 261.714 148.352Z"
            fill="#3E4EB8"
          />
          <path
            d="M287.795 151C288.025 151.169 288.075 151.491 287.906 151.721C287.738 151.951 287.415 152.001 287.185 151.832C285.154 150.344 283.549 150.297 282.197 151.619C281.993 151.818 281.666 151.814 281.467 151.611C281.268 151.407 281.272 151.081 281.476 150.881C283.223 149.173 285.387 149.236 287.795 151Z"
            fill="#3E4EB8"
          />
          <path
            d="M285.813 238.715C284.568 232.953 262.795 228.391 257.159 233.153C256.942 233.337 256.915 233.663 257.098 233.88C257.282 234.098 257.608 234.125 257.825 233.941C260.258 231.885 266.334 231.617 272.994 233.013C279.342 234.343 284.351 236.831 284.805 238.933C284.865 239.211 285.14 239.388 285.418 239.328C285.697 239.268 285.873 238.993 285.813 238.715Z"
            fill="#3E4EB8"
          />
          <path
            d="M287.382 225.26C287.665 225.229 287.919 225.434 287.95 225.717C287.98 226.001 287.775 226.255 287.492 226.285C283.599 226.704 281.521 228.296 281.104 231.091C281.062 231.372 280.8 231.567 280.518 231.525C280.236 231.483 280.042 231.22 280.084 230.939C280.578 227.627 283.061 225.725 287.382 225.26Z"
            fill="#3E4EB8"
          />
          <path
            d="M271.402 207.172C271.521 206.913 271.828 206.8 272.086 206.92C272.345 207.039 272.458 207.345 272.338 207.604L270.006 212.657C269.963 212.75 269.893 212.828 269.805 212.882C265.033 215.784 261.788 218.818 260.062 221.972C259.925 222.222 259.612 222.314 259.362 222.177C259.112 222.04 259.02 221.727 259.157 221.477C260.965 218.174 264.294 215.047 269.135 212.082L271.402 207.172Z"
            fill="#3E4EB8"
          />
          <path
            d="M230.561 317.373C228.9 301.742 228.454 292.318 229.223 289.103C229.398 288.373 229.612 287.739 229.86 287.201C229.873 287.032 229.89 286.858 229.91 286.679C230.498 281.56 246.443 267.371 249.29 265.981C252.137 264.592 255.784 264.762 255.196 269.879C254.652 274.623 242.491 285.523 237.275 289.122C238.994 295.777 234.812 316.202 234.456 318.205C234.452 318.23 234.447 318.254 234.443 318.277C234.896 318.915 235.053 319.841 234.947 321.058C234.905 321.531 235.881 324.157 235.036 324.916C234.192 325.675 234.092 322.73 233.735 323.471C233.038 324.916 230.872 329.36 230.228 329.245C229.584 329.131 231.902 324.495 231.656 324.418C231.403 324.34 229.329 329.202 228.515 329.1C227.702 328.997 230.817 324.254 230.576 324.106C230.335 323.958 228.024 328.16 227.303 328.009C226.582 327.857 229.373 324.205 229.267 323.974C229.16 323.743 226.699 326.665 226.4 326.21C226.101 325.756 227.938 324.446 228.384 323.216C229.438 320.313 228.831 317.977 230.561 317.373Z"
            fill="#FFAA83"
          />
          <path
            d="M302.128 322.548C300.912 317.219 297.269 301.241 298.582 295.444C293.309 291.944 280.944 281.247 280.316 276.511C279.64 271.404 283.283 271.17 286.154 272.51C289.025 273.85 305.215 287.758 305.892 292.866C305.916 293.045 305.935 293.219 305.951 293.387C306.209 293.921 306.434 294.552 306.621 295.278C307.448 298.486 307.164 307.945 305.769 323.656C306.683 324.862 305.484 326.754 305.432 329.602C305.408 330.911 306.653 332.792 306.211 333.109C305.769 333.427 304.519 329.817 304.336 329.994C304.154 330.172 305.451 334.582 304.723 334.465C303.996 334.348 303.344 329.596 303.066 329.648C302.789 329.7 303.997 335.245 303.201 335.049C302.405 334.853 302.211 329.57 301.947 329.553C301.69 329.536 302.191 334.695 301.55 334.571C300.908 334.447 300.478 329.522 300.345 327.923C300.277 327.103 299.128 329.817 298.612 328.806C298.096 327.794 299.948 325.692 300.079 325.236C300.509 323.737 301.169 322.834 302.128 322.548Z"
            fill="#FFAA83"
          />
          <path
            d="M266.468 293.28L258.016 291.015C260.444 284.976 261.638 280.521 261.597 277.651C261.535 273.345 268.908 276.253 270.049 279.915C270.81 282.357 269.617 286.812 266.468 293.28Z"
            fill="#FFAA83"
          />
          <path
            d="M258.475 281.811C264.682 283.474 270.433 296.847 268.802 302.935C267.171 309.023 260.816 312.61 254.608 310.946C248.401 309.283 244.691 302.999 246.322 296.911C247.953 290.824 252.267 280.148 258.475 281.811Z"
            fill="#FFAA83"
          />
          <path
            d="M264.179 301.258C263.898 301.304 263.632 301.115 263.585 300.834C263.538 300.553 263.728 300.287 264.009 300.24C264.711 300.123 264.912 299.672 264.622 298.57C264.55 298.294 264.714 298.012 264.99 297.94C265.265 297.868 265.547 298.032 265.62 298.308C266.048 299.938 265.564 301.027 264.179 301.258Z"
            fill="#ED5738"
          />
          <path
            d="M260.562 283.555C260.362 283.352 260.365 283.026 260.568 282.826C260.771 282.627 261.098 282.629 261.298 282.832C262.544 284.1 263.385 285.173 263.825 286.067C263.95 286.323 263.845 286.632 263.589 286.758C263.334 286.883 263.025 286.778 262.899 286.522C262.517 285.745 261.738 284.751 260.562 283.555Z"
            fill="#ED5738"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M273.427 309.106L274.814 309.731C275.073 309.848 275.189 310.154 275.072 310.413C274.955 310.673 274.649 310.788 274.39 310.671L273.748 310.382L274.277 310.907C274.479 311.108 274.48 311.435 274.279 311.637C274.079 311.839 273.752 311.84 273.55 311.639L272.758 310.853C272.701 310.964 272.641 311.076 272.577 311.187C270.519 314.809 267.746 315.517 264.258 313.313C265.193 318.28 262.456 321.221 256.048 322.134C249.64 323.048 246.229 320.048 245.816 313.133C242.37 314.671 239.441 314.67 237.031 313.13L236.399 314.163C236.25 314.406 235.933 314.483 235.69 314.334C235.447 314.185 235.371 313.868 235.519 313.625L236.196 312.519C235.716 312.119 235.259 311.651 234.824 311.116L232.153 312.826C231.913 312.979 231.594 312.909 231.441 312.67C231.287 312.43 231.357 312.111 231.597 311.957L234.206 310.287C234.179 310.247 234.151 310.207 234.124 310.166L232.337 310.69C232.063 310.771 231.777 310.614 231.697 310.341C231.616 310.067 231.773 309.781 232.046 309.701L233.56 309.257C233.211 308.65 232.88 307.987 232.568 307.27C228.275 297.412 243.004 291.153 246.389 296.278C245.936 297.971 246.302 300.156 247.488 302.832C248.625 300.959 250.363 299.883 252.704 299.603C254.267 299.416 256.476 300.848 259.31 300.829C259.763 300.826 259.73 297.623 260.364 296.893C260.889 296.289 261.153 297.046 261.506 297.199C262.053 297.436 261.698 299.02 262.871 301.239C264.043 303.458 268.48 301.109 265.036 295.696C266.396 290.618 270.53 292.95 272.034 294.441C273.537 295.933 271.833 298.742 271.527 299.884C271.261 300.878 274.587 304.584 273.427 309.106Z"
            fill="#253238"
          />
          <path
            d="M278.587 283.679C273.363 288.055 256.583 281.063 252.304 275.215C248.025 269.367 258.278 255.946 256.404 239.078C255.647 232.269 278.879 232.867 285.052 240.78C287.236 243.581 280.52 245.009 284.268 256.898C287.697 267.778 285.43 277.947 278.587 283.679Z"
            fill="#FFAA83"
          />
          <path
            d="M285.462 271.848C289.503 273.133 295.647 275.046 296.175 279.03C296.852 284.138 292.356 291.224 287.99 288.749C285.588 287.387 282.672 284.872 280.422 282.035C279.859 282.616 279.248 283.165 278.587 283.679C276.74 285.115 273.563 285.254 270.014 284.581C270.45 282.852 270.697 278.315 267.025 276.432C263.352 274.548 261.744 275.895 261.057 281.551C258.241 280.204 255.691 278.59 253.904 276.958C251.94 279.187 249.672 281.105 247.733 282.249C243.41 284.8 238.791 277.795 239.379 272.675C239.934 267.836 248.791 265.895 252.164 264.523C252.914 261.188 253.521 257.086 252.304 251.56C252.224 251.197 254.044 250.8 253.945 250.425C253.584 249.061 251.263 249.395 251.814 248.404C255.771 241.279 280.488 243.478 285.907 250.425C288.091 253.226 284.394 251.931 284.394 252.695C284.394 253.258 285.666 253.526 285.907 254.586C286.147 255.646 284.938 257.494 285.15 258.558C286.047 263.042 286.263 267.643 285.462 271.848Z"
            fill="#F95B03"
          />
          <path
            d="M271.022 281.062C271.126 281.328 270.994 281.627 270.729 281.73C270.464 281.834 270.165 281.702 270.061 281.437C268.777 278.143 267.226 276.377 265.452 276.063C263.686 275.751 262.575 276.275 261.968 277.671C261.854 277.932 261.55 278.051 261.289 277.938C261.028 277.824 260.908 277.52 261.022 277.259C261.829 275.405 263.416 274.656 265.631 275.048C267.838 275.438 269.62 277.468 271.022 281.062Z"
            fill="white"
          />
          <path
            d="M239.376 270.853C239.434 270.574 239.707 270.395 239.986 270.453C240.265 270.512 240.444 270.785 240.386 271.064C239.184 276.823 241.083 280.524 246.149 282.344C246.417 282.44 246.556 282.736 246.46 283.004C246.364 283.272 246.068 283.411 245.8 283.315C240.235 281.315 238.072 277.101 239.376 270.853Z"
            fill="white"
          />
          <path
            d="M296.147 277.208C297.559 283.433 295.47 287.684 289.941 289.78C289.675 289.881 289.377 289.747 289.276 289.481C289.175 289.215 289.309 288.917 289.575 288.816C294.608 286.908 296.443 283.175 295.141 277.437C295.078 277.159 295.252 276.883 295.53 276.82C295.807 276.757 296.084 276.931 296.147 277.208Z"
            fill="white"
          />
          <path
            d="M279.547 269.569C282.09 270.202 283.804 270.861 284.719 271.576C284.944 271.752 284.983 272.076 284.808 272.3C284.632 272.525 284.308 272.564 284.084 272.389C283.314 271.787 281.709 271.17 279.297 270.569C279.021 270.501 278.853 270.221 278.922 269.944C278.99 269.668 279.27 269.5 279.547 269.569Z"
            fill="#253238"
          />
          <path
            d="M252.335 263.011C252.463 262.756 252.773 262.653 253.027 262.781C253.282 262.908 253.385 263.218 253.258 263.472C252.372 265.244 251.932 266.93 251.932 268.533C251.932 268.818 251.701 269.048 251.416 269.048C251.132 269.048 250.901 268.818 250.901 268.533C250.901 266.761 251.381 264.92 252.335 263.011Z"
            fill="#253238"
          />
          <path
            d="M254.683 249.632C254.463 249.812 254.138 249.779 253.957 249.559C253.777 249.338 253.809 249.014 254.03 248.833C255.85 247.344 259.19 246.867 264.068 247.339C264.351 247.366 264.559 247.618 264.531 247.902C264.504 248.185 264.252 248.393 263.968 248.365C259.338 247.917 256.237 248.36 254.683 249.632Z"
            fill="#253238"
          />
          <g opacity="0.54">
            <path
              d="M264.771 406.888C295.117 406.888 351.668 413.529 353.731 426.961C355.793 440.394 318.816 451.739 267.866 451.739C217.064 451.739 181.742 437.27 181.742 426.961C181.742 416.652 234.513 406.888 264.771 406.888Z"
              fill="url(#paint0_linear_7659_5146)"
            />
            <path
              d="M167.292 418.284L153.376 430.408H175.336L166.141 440.323H141.993L132.955 448.197H85.3018L97.5386 440.323H12.8828L30.2906 432.845L142.644 402.109H174.431L84.2522 430.408H112.95L120.323 425.664L143.625 418.284H167.292Z"
              fill="url(#paint1_linear_7659_5146)"
            />
            <path
              d="M500.496 418.284L486.579 430.408H508.539L499.345 440.323H475.196L466.158 448.197H418.505L430.742 440.323H346.086L363.494 432.845L475.847 402.109H507.634L417.455 430.408H446.153L453.526 425.664L476.828 418.284H500.496Z"
              fill="url(#paint2_linear_7659_5146)"
            />
          </g>
          <path
            d="M181.906 428.261L241.007 51.2607H295.777L347.789 387.105C345.378 391.423 345.587 394.505 345.587 396.375C345.587 398.245 346.774 404.689 350.907 408.048L353.906 428.261"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M265.024 86.1747C316.663 86.1747 358.525 75.7212 358.525 62.8261C358.525 49.9311 316.663 39.4775 265.024 39.4775C213.385 39.4775 171.523 49.9311 171.523 62.8261C171.523 75.7212 213.385 86.1747 265.024 86.1747Z"
            fill="#8FD8FC"
          />
          <path
            d="M267.604 82.5648C323.515 82.5648 368.84 72.1113 368.84 59.2162C368.84 46.3212 323.515 35.8677 267.604 35.8677C211.692 35.8677 166.367 46.3212 166.367 59.2162C166.367 72.1113 211.692 82.5648 267.604 82.5648Z"
            fill="#465197"
          />
          <path
            d="M267.604 77.4081C323.515 77.4081 368.84 66.9546 368.84 54.0595C368.84 41.1644 323.515 30.7109 267.604 30.7109C211.692 30.7109 166.367 41.1644 166.367 54.0595C166.367 66.9546 211.692 77.4081 267.604 77.4081Z"
            fill="#8FD8FC"
          />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M310.203 43.5978C310.203 20.0717 291.132 1 267.606 1C244.079 1 225.008 20.0717 225.008 43.5978C225.008 52.5307 310.203 54.4913 310.203 43.5978Z"
            fill="white"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M231.246 226.241L208.555 425.046"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M290.812 108.659L303.963 209.222"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M312.211 284.773L316.852 332.218"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M291.328 370.109L293.133 424.258"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M250.581 342.261L247.75 372.945"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M247.753 393.574L244.922 424.258"
            stroke="#465197"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M221.447 64.1158C226.858 64.1158 231.245 61.9224 231.245 59.2166C231.245 56.5108 226.858 54.3174 221.447 54.3174C216.035 54.3174 211.648 56.5108 211.648 59.2166C211.648 61.9224 216.035 64.1158 221.447 64.1158Z"
            stroke="white"
            strokeWidth="3"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M311.697 64.1158C317.108 64.1158 321.495 61.9224 321.495 59.2166C321.495 56.5108 317.108 54.3174 311.697 54.3174C306.285 54.3174 301.898 56.5108 301.898 59.2166C301.898 61.9224 306.285 64.1158 311.697 64.1158Z"
            stroke="white"
            strokeWidth="3"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M340.752 52.7096C346.163 52.7096 350.55 50.5161 350.55 47.8104C350.55 45.1046 346.163 42.9111 340.752 42.9111C335.34 42.9111 330.953 45.1046 330.953 47.8104C330.953 50.5161 335.34 52.7096 340.752 52.7096Z"
            stroke="white"
            strokeWidth="3"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M194.259 52.7096C199.671 52.7096 204.058 50.5161 204.058 47.8104C204.058 45.1046 199.671 42.9111 194.259 42.9111C188.848 42.9111 184.461 45.1046 184.461 47.8104C184.461 50.5161 188.848 52.7096 194.259 52.7096Z"
            stroke="white"
            strokeWidth="3"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M265.025 69.983C270.437 69.983 274.823 67.7896 274.823 65.0838C274.823 62.378 270.437 60.1846 265.025 60.1846C259.613 60.1846 255.227 62.378 255.227 65.0838C255.227 67.7896 259.613 69.983 265.025 69.983Z"
            stroke="white"
            strokeWidth="3"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <defs>
            <linearGradient
              id="paint0_linear_7659_5146"
              x1="275.689"
              y1="448.812"
              x2="275.689"
              y2="377.418"
              gradientUnits="userSpaceOnUse"
            >
              <stop stop-color="white" />
              <stop offset="1" stop-color="white" stop-opacity="0.3" />
            </linearGradient>
            <linearGradient
              id="paint1_linear_7659_5146"
              x1="101.579"
              y1="445.189"
              x2="101.579"
              y2="371.828"
              gradientUnits="userSpaceOnUse"
            >
              <stop stop-color="white" />
              <stop offset="1" stop-color="white" stop-opacity="0.3" />
            </linearGradient>
            <linearGradient
              id="paint2_linear_7659_5146"
              x1="434.782"
              y1="445.189"
              x2="434.782"
              y2="371.828"
              gradientUnits="userSpaceOnUse"
            >
              <stop stop-color="white" />
              <stop offset="1" stop-color="white" stop-opacity="0.3" />
            </linearGradient>
          </defs>
        </svg>

        <p className=" text-white text-5xl font-medium text-center mt-8">
          Page Not Found
        </p>
        <Link
          href={"/"}
          className="w-fit px-10 h-[62px] rounded bg-primary-blue text-primary-black flex justify-center items-center text-[18px] font-semibold tracking-wider  mt-10"
        >
          Back to Home
        </Link>
      </div>
    </div>
  );
}

export default NotFound;
