import React from "react";
import { useRouter } from "next/navigation";
import StringLang from "@/utilities/StringLang";
function Svg() {
  return (
    <svg
      width="493"
      height="346"
      viewBox="0 0 493 346"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M428.046 331.385C420.515 311.123 409.487 300.991 394.962 300.991C373.176 300.991 383.678 269.09 361.085 269.09C346.377 269.09 346.377 286.846 325.312 275.818C303.593 264.448 326.119 244.835 284.966 241.07C243.814 237.304 253.268 275.818 236.323 275.818C224.119 275.818 223.333 256.415 212.922 254.839C202.512 253.263 201.087 266.135 193.287 264.522C183.784 262.555 187.37 246.228 164.198 246.228C141.027 246.228 148.907 277.768 143.259 281.231C137.61 284.694 130.348 273.129 122.548 286.846C114.748 300.564 128.26 307.019 116.9 307.019C103.057 307.019 95.4189 315.141 93.9844 331.385C95.004 336.358 104.525 339.14 122.548 339.731C149.582 340.619 150.799 332.992 184.343 334.352C217.887 335.712 223.573 334.352 271.746 334.352C319.92 334.352 311.368 345.169 348.146 341.883C384.925 338.597 413.108 345.392 434.217 344.035C445.779 343.292 443.722 339.075 428.046 331.385Z"
        fill="#2D9B56"
      />
      <path
        opacity="0.2"
        d="M192.407 17.8515C192.408 17.79 192.409 17.7291 192.409 17.6688C192.409 7.91059 184.695 0 175.18 0C165.664 0 157.95 7.91059 157.95 17.6688C157.95 17.6999 157.951 17.7311 157.951 17.7625C158.022 24.7472 155.686 31.5435 151.336 37.0087C145.653 44.1493 142.811 50.7024 142.811 56.6678C142.811 59.4041 143.45 62.5067 144.73 65.9755C147.976 74.7784 146.977 84.5871 142.022 92.5544C137.222 100.272 134.822 107.153 134.822 113.195C134.822 117.08 135.858 121.622 137.932 126.822C141.441 135.625 140.646 145.561 135.781 153.693C130.104 163.183 127.266 171.485 127.266 178.6C127.266 205.737 148.718 227.736 175.18 227.736C201.642 227.736 223.094 205.737 223.094 178.6C223.094 171.485 220.255 163.183 214.578 153.693C209.713 145.561 208.918 135.625 212.428 126.822C214.501 121.622 215.538 117.08 215.538 113.195C215.538 107.091 213.091 100.147 208.198 92.3652C203.206 84.4255 202.158 74.6264 205.356 65.8101C206.592 62.4034 207.21 59.356 207.21 56.6678C207.21 50.7769 204.434 44.2915 198.882 37.2116C194.557 31.6971 192.27 24.8581 192.407 17.8515Z"
        fill="#8FD8FC"
      />
      <path
        opacity="0.4"
        d="M175.039 148.536V123.76L192.436 101.036C192.606 100.815 192.564 100.498 192.342 100.328C192.12 100.158 191.803 100.2 191.633 100.422L174.132 123.281C174.064 123.369 174.028 123.477 174.028 123.588V147.215L157.664 125.842C157.494 125.62 157.177 125.578 156.955 125.748C156.733 125.917 156.691 126.235 156.861 126.456L174.028 148.878V151.211C174.028 151.389 174.12 151.545 174.258 151.635V173.598L174.132 173.763C174.064 173.851 174.028 173.959 174.028 174.07V192.52L157.664 171.146C157.494 170.924 157.177 170.882 156.955 171.052C156.733 171.221 156.691 171.539 156.861 171.76L174.028 194.183V201.693C174.028 201.871 174.12 202.027 174.258 202.117V215.363C174.209 215.442 174.182 215.535 174.182 215.63V256.298C174.182 256.577 174.408 256.803 174.687 256.803C174.966 256.803 175.193 256.577 175.193 256.298V222.203C175.241 222.125 175.269 222.034 175.269 221.935V215.757L193.454 197.108C193.649 196.909 193.645 196.589 193.445 196.394C193.245 196.199 192.925 196.203 192.73 196.403L175.269 214.309V194.312C175.269 194.201 175.233 194.093 175.165 194.005L175.039 193.84V177.055C175.177 176.965 175.269 176.809 175.269 176.631V173.941L192.436 151.519C192.606 151.297 192.564 150.98 192.342 150.81C192.12 150.64 191.803 150.682 191.633 150.904L175.269 172.278V149.008C175.269 148.897 175.233 148.789 175.165 148.701L175.039 148.536Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M82.2829 249.702C57.5174 249.702 37.4409 229.113 37.4409 203.715C37.4409 178.318 57.5174 43.8218 82.2829 43.8218C107.049 43.8218 127.125 178.318 127.125 203.715C127.125 229.113 107.049 249.702 82.2829 249.702Z"
        fill="#BFEAFF"
      />
      <path
        opacity="0.4"
        d="M82.1443 189.391V169.792L99.5416 147.069C99.7113 146.847 99.6692 146.53 99.4475 146.361C99.2258 146.191 98.9085 146.233 98.7388 146.455L81.2374 169.314C81.1699 169.402 81.1333 169.51 81.1333 169.621V188.07L64.7691 166.696C64.5994 166.475 64.2821 166.433 64.0605 166.602C63.8388 166.772 63.7967 167.089 63.9664 167.311L81.1333 189.733V197.244C81.1333 197.422 81.225 197.578 81.3637 197.668V211.604L64.7691 189.929C64.5994 189.707 64.2821 189.665 64.0605 189.835C63.8388 190.005 63.7967 190.322 63.9664 190.544L81.3637 213.267V234.146C81.314 234.226 81.2871 234.318 81.2871 234.413V275.081C81.2871 275.36 81.5134 275.587 81.7926 275.587C82.0717 275.587 82.2981 275.36 82.2981 275.081V240.986C82.3466 240.909 82.3747 240.817 82.3747 240.719V234.541L100.56 215.892C100.754 215.692 100.75 215.372 100.551 215.177C100.351 214.982 100.031 214.986 99.8357 215.186L82.3747 233.092V213.096V189.863C82.3747 189.752 82.3381 189.644 82.2705 189.556L82.1443 189.391Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M448.037 262.922C423.271 262.922 403.195 242.333 403.195 216.936C403.195 191.538 423.271 57.042 448.037 57.042C472.802 57.042 492.879 191.538 492.879 216.936C492.879 242.333 472.802 262.922 448.037 262.922Z"
        fill="#8FD8FC"
      />
      <path
        opacity="0.4"
        d="M447.898 202.611V183.013L465.295 160.289C465.465 160.068 465.423 159.75 465.201 159.581C464.98 159.411 464.662 159.453 464.493 159.675L446.991 182.534C446.924 182.622 446.887 182.73 446.887 182.841V201.291L430.523 179.917C430.353 179.695 430.036 179.653 429.814 179.823C429.593 179.992 429.551 180.31 429.72 180.531L446.887 202.954V210.464C446.887 210.642 446.979 210.798 447.118 210.888V224.824L430.523 203.149C430.353 202.928 430.036 202.886 429.814 203.055C429.593 203.225 429.551 203.542 429.72 203.764L447.118 226.487V247.366C447.068 247.446 447.041 247.538 447.041 247.634V288.301C447.041 288.581 447.267 288.807 447.546 288.807C447.826 288.807 448.052 288.581 448.052 288.301V254.206C448.101 254.129 448.129 254.037 448.129 253.939V247.761L466.313 229.112C466.508 228.912 466.504 228.592 466.304 228.397C466.105 228.202 465.785 228.206 465.59 228.406L448.129 246.313V226.316V203.083C448.129 202.972 448.092 202.864 448.024 202.776L447.898 202.611Z"
        fill="white"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M150.236 276.582C150.232 276.73 150.216 276.878 150.186 277.024C149.91 278.377 148.591 279.25 147.238 278.974C145.463 278.612 144.076 277.222 143.72 275.445L122.646 170.512C122.518 169.875 122.432 169.23 122.389 168.581C121.843 160.411 128.024 153.345 136.194 152.799C136.654 152.768 137.115 152.758 137.576 152.769C146.116 152.963 152.882 160.043 152.688 168.582L150.236 276.582Z"
        fill="#FFC55F"
      />
      <path
        d="M131.415 177.401C120.708 181.289 102.618 163.994 108.043 144.482C113.468 124.969 118.273 113.27 113.158 107.211C108.043 101.152 126.537 104.118 126.537 115.746C126.537 127.373 127.945 86.705 142.121 75.687C144.595 89.1755 149.163 99.6834 155.823 107.211C165.814 118.502 163.719 127.415 159.568 138.178C164.373 139.125 166.496 137.937 165.935 134.613C172.334 140.667 166.107 166.15 151.224 173.158C136.342 180.166 142.121 173.513 131.415 177.401Z"
        fill="#F95B03"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M152.713 172.378C152.226 172.659 151.729 172.919 151.222 173.158C136.339 180.166 142.118 173.513 131.412 177.401C129.212 178.2 126.701 178.104 124.146 177.279L122.99 170.119C122.933 169.765 122.889 169.41 122.858 169.053C122.148 160.939 128.151 153.785 136.265 153.075C136.545 153.05 136.825 153.034 137.106 153.025C145.385 152.767 152.305 159.27 152.563 167.549L152.713 172.378Z"
        fill="#EC961F"
      />
      <path
        d="M132.973 167.041L137.884 157.445C138.687 155.876 141.041 157.081 140.238 158.65L135.327 168.246C134.524 169.815 132.17 168.61 132.973 167.041Z"
        fill="#1C2229"
      />
      <path
        d="M137.84 169.471L142.751 159.875C143.554 158.306 145.908 159.511 145.105 161.08L140.194 170.676C139.391 172.245 137.037 171.04 137.84 169.471Z"
        fill="#1C2229"
      />
      <path
        d="M143.723 252.937C149.933 249.205 137.327 228.111 134.99 227.094C131.092 225.397 125.071 234.819 124.353 239.354C123.454 245.026 132.298 252.613 136.863 255.498C137.234 255.732 139.273 257.493 139.81 257.404C140.294 257.324 139.714 255.02 140.261 254.776C141.655 254.156 142.694 253.555 143.723 252.937Z"
        fill="#FFAA83"
      />
      <path
        d="M221.1 262.165L215.992 254.008"
        stroke="#ED5738"
        strokeWidth="4.84853"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M158.189 236.278C173.65 240.36 196.71 246.824 215.985 254.027C207.483 227.194 199.328 190.862 205.169 178.627C213.611 160.945 225.747 167.742 232.143 177.957C238.392 187.936 260.377 262.469 253.519 282.401C256.169 294.396 248.825 300.014 233.382 296.854C222.458 294.619 196.256 281.252 154.775 256.756C152.867 257.141 150.283 255.938 149.198 254.374C148.91 253.958 148.652 253.492 148.418 252.986C144.436 250.615 140.323 248.148 136.08 245.586C135.454 242.225 135.205 239.472 135.335 237.329C135.315 237.321 135.295 237.313 135.275 237.304C128.71 234.412 139.245 222.156 143.319 223.655C146.026 224.651 149.531 224.105 153.893 228.033C155.798 229.749 157.267 232.783 158.189 236.278Z"
        fill="#FFAA83"
      />
      <path
        d="M132.601 233.746C133.317 232.622 134.657 231.013 136.606 228.947C137.107 228.416 137.082 227.58 136.551 227.078C136.02 226.577 135.184 226.602 134.683 227.133C132.629 229.31 131.197 231.03 130.372 232.325C129.908 233.053 129.614 233.675 129.498 234.239C129.319 235.104 129.557 235.923 130.305 236.404C132.513 237.827 135.744 238.03 139.964 236.54C141.144 236.123 142.16 235.736 143.019 235.373C142.534 237.991 142.86 240.483 144.012 242.813C144.805 244.417 145.566 245.528 146.364 246.172C147.456 247.054 148.737 247.106 149.764 246.208C150.314 245.727 150.37 244.892 149.89 244.343C149.428 243.814 148.638 243.742 148.089 244.164C148.07 244.15 148.048 244.134 148.025 244.115C147.591 243.765 147.02 242.931 146.382 241.641C145.128 239.104 145.128 236.33 146.418 233.221C146.949 231.942 145.405 230.811 144.345 231.704C143.727 232.225 141.931 233.041 139.084 234.047C135.942 235.156 133.699 235.146 132.208 234.443C132.295 234.257 132.426 234.021 132.601 233.746Z"
        fill="#ED5738"
      />
      <path
        d="M216.061 156.918C234.024 140.159 349.266 156.834 357.064 171.738C364.862 186.642 342.045 286.465 320.361 299.464C298.677 312.462 248.199 313.828 228.942 289.855C209.686 265.883 198.099 173.678 216.061 156.918Z"
        fill="#FFAA83"
      />
      <path
        d="M214.841 239.23C204.502 239.682 195.427 235.807 194.012 226.066C191.265 207.152 195.965 174.167 209.655 160.12C214.574 155.074 218.908 153.179 222.566 153.367C230.054 150.783 241.677 149.774 255.03 149.926C265.919 150.05 242.757 221.701 280.906 225.711C329.205 230.787 307.617 154.869 315.819 156.478C337.206 160.672 354.229 166.322 357.063 171.738C363.467 183.979 349.221 253.501 331.912 285.158C328.146 292.046 343.355 322.106 339.48 324.429C320.573 335.763 308.411 333.862 274.135 334.812C239.859 335.763 220.061 318.917 220.607 312.288C221.488 301.608 223.264 285.773 221.148 272.251C220.077 265.413 217.43 253.245 214.841 239.23Z"
        fill="#5296FB"
      />
      <path
        d="M252.952 182.812C252.869 181.793 253.627 180.9 254.645 180.816C255.664 180.732 256.558 181.49 256.641 182.509C258.792 208.691 266.937 222.168 280.866 223.632C290.713 224.667 298.779 220.507 304.666 212.151C309.951 204.649 313.12 194.116 313.543 183.478C313.584 182.457 314.445 181.662 315.466 181.702C316.487 181.743 317.282 182.604 317.242 183.625C316.792 194.938 313.416 206.158 307.692 214.283C301.069 223.683 291.737 228.497 280.479 227.313C264.335 225.617 255.23 210.552 252.952 182.812Z"
        fill="white"
      />
      <path
        d="M212.236 235.263C206.11 233.821 199.51 230.287 193.687 225.035C193.144 224.546 193.101 223.71 193.59 223.168C194.079 222.626 194.915 222.583 195.457 223.072C201.155 228.21 206.965 231.404 212.912 232.651C213.417 234.453 214.444 235.263 212.236 235.263Z"
        fill="white"
      />
      <path
        d="M215.317 237.248C215.532 237.945 215.141 238.686 214.443 238.901C213.746 239.116 213.006 238.725 212.79 238.027C209.901 228.665 208.697 221.922 209.208 217.694C209.295 216.97 209.954 216.453 210.679 216.54C211.404 216.628 211.92 217.287 211.833 218.011C211.379 221.77 212.53 228.217 215.317 237.248Z"
        fill="#1D5EF8"
      />
      <path
        d="M252.116 165.424C247.383 163.923 238.859 156.414 240.212 150.556C241.617 144.47 246.475 140.395 251.064 141.454C251.242 141.495 251.418 141.544 251.59 141.599C251.747 140.611 251.93 139.658 252.141 138.744C257.094 117.294 278.839 103.998 300.712 109.048C322.584 114.098 336.301 135.58 331.349 157.031C326.397 178.481 301.046 213.598 279.174 208.548C264.635 205.191 255.292 184.932 252.116 165.424Z"
        fill="#FFAA83"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M275.179 140.472L282.618 147.409C283.555 148.283 283.606 149.75 282.733 150.687C281.859 151.623 280.392 151.674 279.456 150.801L272.016 143.864C271.079 142.99 271.028 141.523 271.902 140.586C272.775 139.65 274.242 139.598 275.179 140.472Z"
        fill="#253238"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M308.409 146.486L317.905 142.841C319.101 142.382 320.442 142.979 320.901 144.175C321.36 145.37 320.763 146.711 319.567 147.17L310.071 150.816C308.875 151.275 307.534 150.677 307.075 149.482C306.616 148.286 307.213 146.945 308.409 146.486Z"
        fill="#22537F"
      />
      <path
        d="M295.77 151.363C292.181 160.054 291.53 165.615 293.818 168.047C296.107 170.479 298.303 171.938 300.408 172.424C297.238 175.183 294.346 176.736 291.732 177.085C287.811 177.607 281.728 174.575 285.656 172.25"
        stroke="#ED5738"
        strokeWidth="4.84853"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M249.687 145.633C250.386 145.423 251.123 145.82 251.333 146.519C251.543 147.219 251.146 147.956 250.447 148.166C246.406 149.379 245.69 151.155 247.839 154.451C248.238 155.062 248.065 155.881 247.454 156.28C246.842 156.679 246.023 156.507 245.624 155.895C242.487 151.083 243.995 147.343 249.687 145.633Z"
        fill="#ED5738"
      />
      <path
        d="M274.156 185.651C273.426 185.638 272.845 185.035 272.858 184.305C272.871 183.575 273.474 182.994 274.204 183.008C283.664 183.181 290.243 187.961 293.728 197.166C293.986 197.849 293.642 198.612 292.959 198.87C292.277 199.129 291.514 198.785 291.255 198.102C288.148 189.895 282.519 185.805 274.156 185.651Z"
        fill="#ED5738"
      />
      <path
        d="M258.321 188.286C258.093 187.593 258.47 186.846 259.164 186.617C259.857 186.389 260.605 186.766 260.833 187.46C264.59 198.871 270.996 205.54 280.105 207.643C289.183 209.739 297.934 206.128 306.477 196.637C306.965 196.094 307.801 196.05 308.344 196.539C308.887 197.027 308.931 197.863 308.442 198.406C299.305 208.558 289.621 212.553 279.51 210.219C269.43 207.892 262.349 200.522 258.321 188.286Z"
        fill="#ED5738"
      />
      <path
        d="M269.795 155.893L276.652 154.567L271.027 150.96C270.413 150.565 270.234 149.748 270.628 149.133C271.022 148.518 271.84 148.34 272.455 148.734L280.861 154.124C281.865 154.768 281.57 156.309 280.398 156.535L270.297 158.488C269.58 158.627 268.886 158.158 268.748 157.441C268.609 156.725 269.078 156.031 269.795 155.893Z"
        fill="#1C2229"
      />
      <path
        d="M309.455 164.966C310.997 165.322 312.535 164.361 312.891 162.82C313.247 161.278 312.285 159.74 310.744 159.385C309.203 159.029 307.665 159.99 307.309 161.531C306.953 163.073 307.914 164.611 309.455 164.966Z"
        fill="#1C2229"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M236.347 113.513L230.694 111.196C229.748 110.809 229.295 109.728 229.683 108.782C230.071 107.836 231.151 107.384 232.097 107.771L234.233 108.646L232.43 106.975C231.681 106.28 231.636 105.109 232.331 104.359C233.026 103.61 234.197 103.566 234.947 104.261L237.85 106.952C238.02 106.543 238.205 106.144 238.407 105.755C244.747 93.5069 248.885 90.3007 261.164 95.6178C282.326 47.2773 314.759 52.994 323.662 78.2738C336.148 62.6174 347.56 62.7839 355.973 68.3121L357.985 64.7482C358.488 63.8581 359.617 63.5439 360.507 64.0464C361.397 64.549 361.711 65.678 361.209 66.5681L358.943 70.5804C360.628 72.0549 362.156 73.7272 363.506 75.4853L373.332 68.6915C374.173 68.1101 375.325 68.3205 375.907 69.1612C376.488 70.002 376.278 71.1549 375.437 71.7362L365.619 78.5247C365.647 78.5702 365.676 78.6158 365.704 78.6613L372.951 76.2534C373.921 75.931 374.969 76.4561 375.291 77.4261C375.613 78.3962 375.088 79.4438 374.118 79.7661L367.543 81.951C368.516 83.9082 369.251 85.8091 369.722 87.5109C402.241 82.5333 415.576 109.13 375.958 125.214C378.777 143.874 355.419 149.464 347.056 144.578C346.563 160.881 332.894 169.699 325.741 169.929C327.339 167.376 330.127 159.691 331.269 154.746C328.775 145.609 326.891 142.97 327.796 132.104C320.544 136.925 307.175 138.192 294.858 140.108C289.375 140.961 271.387 138.87 265.898 131.093C264.01 139.272 263.965 147.81 258.228 159.38C253.575 160.909 255.719 145.906 252.895 143.079C249.571 139.751 245.188 143.667 242.978 144.49C241.744 141.365 235.3 125.804 236.347 113.513Z"
        fill="#253238"
      />
      <path
        d="M366.156 195.452C366.497 204.961 361.844 255.239 342.46 285.398C338.212 292.006 339.342 295.443 336.178 300.583C323.952 320.449 303.414 324.153 303.414 287.897C303.414 278.769 310.632 270.819 312.196 262.626C317.55 234.579 329.959 191.13 342.46 182.545C358.612 171.453 365.724 183.407 366.156 195.452Z"
        fill="#FFAA83"
      />
      <path
        d="M365.633 181.211C365.998 193.027 368.07 212.455 368.13 230.157C368.189 247.859 318.049 261.158 314.185 230.157C310.322 199.156 327.466 168.408 342.124 168.408C356.782 168.408 365.261 169.16 365.633 181.211Z"
        fill="#5296FB"
      />
      <path
        d="M365.422 232.65C346.991 247.915 329.358 248.208 312.999 233.456C312.457 232.967 312.414 232.131 312.903 231.589C313.392 231.047 314.228 231.003 314.77 231.492C330.121 245.336 346.284 245.067 363.736 230.613C364.298 230.148 365.132 230.226 365.597 230.788C366.063 231.351 365.985 232.184 365.422 232.65Z"
        fill="white"
      />
      <path
        d="M317.424 230.573C319.603 221.02 321.932 214.579 324.488 211.173C324.926 210.589 325.755 210.471 326.339 210.909C326.923 211.347 327.041 212.176 326.603 212.76C324.33 215.788 322.104 221.947 320.002 231.161C319.839 231.873 319.131 232.318 318.419 232.156C317.707 231.993 317.262 231.285 317.424 230.573Z"
        fill="#1D5EF8"
      />
      <path
        d="M312.992 263.249V257.823C312.992 257.092 313.584 256.5 314.314 256.5C315.044 256.5 315.636 257.092 315.636 257.823V263.249C315.636 263.979 315.044 264.571 314.314 264.571C313.584 264.571 312.992 263.979 312.992 263.249Z"
        fill="#ED5738"
      />
      <path
        d="M335.793 288.343C337.505 283.929 337.508 276.971 335.735 267.523C332.979 257.104 332.447 250.809 334.408 248.163C334.843 247.576 335.671 247.453 336.257 247.888C336.844 248.323 336.967 249.15 336.533 249.737C335.269 251.443 335.769 257.321 338.325 266.987C340.189 276.9 340.189 284.32 338.258 289.3C337.994 289.98 337.228 290.318 336.547 290.054C335.867 289.79 335.529 289.024 335.793 288.343Z"
        fill="#ED5738"
      />
      <path
        d="M286.396 250.706C284.291 248.111 284.982 247.108 284.137 243.895C283.846 242.789 285.174 241.037 285.001 239.866C284.873 238.996 283.538 237.739 283.551 236.857C283.574 235.288 284.7 233.741 285.001 232.134C285.266 230.722 283.312 229.58 284.137 227.288C284.962 224.996 287.26 224.746 288.097 223.536C288.762 222.574 285.318 221.156 288.097 218.377C290.876 215.598 299.135 214.555 303.253 216.501C301.994 224.378 309.014 224.825 312.963 222.46C313.96 221.863 313.644 217.021 315.174 217.021C316.46 217.021 319.814 217.021 321.598 218.377C332.091 226.354 335.455 232.049 334.193 248.344C333.563 256.476 310.895 257.915 303.253 256.321C298.849 255.402 289.44 254.458 286.396 250.706Z"
        fill="#FFAA83"
      />
      <path
        d="M305.125 208.422L315.901 210.712L312.387 227.747L301.611 225.456L305.125 208.422Z"
        fill="#1E5B89"
      />
      <path
        d="M315.259 212.503C334.851 212.503 350.733 196.62 350.733 177.029C350.733 157.437 334.851 141.555 315.259 141.555C295.667 141.555 279.785 157.437 279.785 177.029C279.785 196.62 295.667 212.503 315.259 212.503Z"
        fill="#4C91FC"
      />
      <path
        d="M315.258 208.977C332.659 208.977 346.766 194.871 346.766 177.469C346.766 160.068 332.659 145.961 315.258 145.961C297.857 145.961 283.75 160.068 283.75 177.469C283.75 194.871 297.857 208.977 315.258 208.977Z"
        fill="white"
      />
      <path
        d="M345.152 167.487C342.556 179.687 334.763 195.522 324.611 207.566C321.656 208.483 318.515 208.977 315.258 208.977C297.857 208.977 283.75 194.871 283.75 177.469C283.75 160.068 297.857 145.961 315.258 145.961C329.17 145.961 340.977 154.978 345.152 167.487Z"
        fill="#FFAA83"
      />
      <path
        d="M315.479 190.469C324.971 190.469 332.665 182.774 332.665 173.283C332.665 163.791 324.971 156.097 315.479 156.097C305.987 156.097 298.293 163.791 298.293 173.283C298.293 182.774 305.987 190.469 315.479 190.469Z"
        fill="white"
      />
      <path
        d="M315.919 182.537C320.786 182.537 324.732 178.591 324.732 173.724C324.732 168.856 320.786 164.91 315.919 164.91C311.051 164.91 307.105 168.856 307.105 173.724C307.105 178.591 311.051 182.537 315.919 182.537Z"
        fill="#22537F"
      />
      <path
        d="M315.918 178.13C318.352 178.13 320.325 176.157 320.325 173.724C320.325 171.29 318.352 169.317 315.918 169.317C313.485 169.317 311.512 171.29 311.512 173.724C311.512 176.157 313.485 178.13 315.918 178.13Z"
        fill="#1C2229"
      />
      <path
        d="M321.87 174.164C324.182 174.164 326.056 172.29 326.056 169.978C326.056 167.666 324.182 165.792 321.87 165.792C319.558 165.792 317.684 167.666 317.684 169.978C317.684 172.29 319.558 174.164 321.87 174.164Z"
        fill="white"
      />
      <path
        d="M348.067 340.206C343.858 333.512 334.253 330.165 319.251 330.165C296.75 330.165 300.764 318.022 277.429 318.022C254.094 318.022 268.115 272.128 211.378 269.7C154.642 267.272 167.486 296.414 149.985 296.414C132.483 296.414 123.073 282.134 101.647 283.143C80.2219 284.151 71.5793 316.209 62.9675 318.022C54.3557 319.834 60.7451 311.678 37.1321 311.678C21.3901 311.678 10.2781 317.841 3.79611 330.165C-5.23494 336.859 4.13953 340.206 31.9195 340.206C42.1469 340.206 70.3156 336.944 101.647 336.037C119.329 335.525 151.61 345.281 192.21 345.281C211.378 345.281 227.804 340.923 265.272 340.206C290.25 339.728 317.848 339.728 348.067 340.206Z"
        fill="#37CE6F"
      />
    </svg>
  );
}
function NoResultFound() {
  const router = useRouter();
  return (
    <div className="w-full">
      <div className="w-full flex justify-center mb-5">
        <Svg />
      </div>
      <p className="text-center font-semibold text-[26px] text-white mb-6">
        <StringLang string="No Result Found" />
      </p>
      <div className="w-full flex justify-center">
        <button onClick={() => router.back()} type="button">
          <div className="py-4 px-8 flex rtl:space-x-reverse space-x-2.5 items-center bg-primary-blue group  hover:bg-white hover:text-black  common-transition rounded-[5px]">
            <span className="text-primary-black text-base  common-transition group-hover:text-black font-medium leading-5">
              <StringLang string="Go Back!" />
            </span>
          </div>
        </button>
      </div>
    </div>
  );
}

export default NoResultFound;
