import React from "react";
import StringLang from "@/utilities/StringLang";
import { useRouter } from "next/navigation";

function Svg() {
  return (
    <svg
      width="479"
      height="337"
      viewBox="0 0 479 337"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M415.191 321.787C407.878 302.112 397.17 292.274 383.066 292.274C361.91 292.274 372.109 261.297 350.17 261.297C335.887 261.297 335.887 278.538 315.433 267.83C294.343 256.789 316.216 237.744 276.256 234.088C236.295 230.431 245.475 267.83 229.021 267.83C217.17 267.83 216.407 248.988 206.298 247.458C196.189 245.927 194.806 258.427 187.232 256.86C178.003 254.951 181.486 239.096 158.985 239.096C136.485 239.096 144.137 269.723 138.652 273.086C133.167 276.449 126.115 265.218 118.541 278.538C110.967 291.858 124.088 298.127 113.056 298.127C99.6149 298.127 92.1977 306.014 90.8047 321.787C91.7947 326.616 101.04 329.317 118.541 329.892C144.792 330.754 145.974 323.348 178.547 324.668C211.119 325.989 216.64 324.668 263.418 324.668C310.197 324.668 301.892 335.172 337.606 331.981C373.319 328.791 400.686 335.389 421.183 334.071C432.411 333.349 430.413 329.254 415.191 321.787Z"
        fill="#121313"
      />
      <path
        opacity="0.2"
        d="M186.378 17.3345C186.379 17.2748 186.38 17.2157 186.38 17.1571C186.38 7.68148 178.889 0 169.649 0C160.41 0 152.919 7.68148 152.919 17.1571C152.919 17.1873 152.919 17.2176 152.92 17.2481C152.989 24.0305 150.721 30.6299 146.497 35.9368C140.978 42.8707 138.218 49.234 138.218 55.0266C138.218 57.6837 138.839 60.6964 140.081 64.0648C143.234 72.6127 142.263 82.1373 137.452 89.8738C132.791 97.3682 130.46 104.049 130.46 109.917C130.46 113.689 131.467 118.1 133.48 123.149C136.888 131.697 136.116 141.345 131.392 149.242C125.879 158.457 123.123 166.518 123.123 173.427C123.123 199.779 143.954 221.141 169.649 221.141C195.345 221.141 216.176 199.779 216.176 173.427C216.176 166.518 213.42 158.457 207.907 149.242C203.183 141.345 202.411 131.697 205.819 123.149C207.832 118.1 208.838 113.689 208.838 109.917C208.838 103.989 206.463 97.2468 201.712 89.6901C196.864 81.9803 195.846 72.4651 198.952 63.9041C200.152 60.5961 200.752 57.6369 200.752 55.0266C200.752 49.3063 198.057 43.0087 192.665 36.1339C188.465 30.7791 186.245 24.1382 186.378 17.3345Z"
        fill="#8FD8FC"
      />
      <path
        opacity="0.4"
        d="M169.514 144.234V120.175L186.407 98.1101C186.572 97.8948 186.531 97.5867 186.316 97.4219C186.101 97.2571 185.793 97.298 185.628 97.5133L168.633 119.71C168.568 119.796 168.532 119.901 168.532 120.009V142.952L152.642 122.197C152.477 121.982 152.169 121.941 151.954 122.106C151.738 122.27 151.698 122.578 151.862 122.794L168.532 144.567V146.832C168.532 147.004 168.621 147.156 168.756 147.244V168.57L168.633 168.73C168.568 168.816 168.532 168.921 168.532 169.029V186.944L152.642 166.189C152.477 165.974 152.169 165.933 151.954 166.098C151.738 166.262 151.698 166.571 151.862 166.786L168.532 188.559V195.852C168.532 196.024 168.621 196.176 168.756 196.264V209.125C168.708 209.202 168.681 209.292 168.681 209.385V248.875C168.681 249.146 168.901 249.366 169.172 249.366C169.443 249.366 169.663 249.146 169.663 248.875V215.767C169.71 215.692 169.738 215.603 169.738 215.507V209.508L187.396 191.4C187.585 191.206 187.581 190.895 187.387 190.706C187.193 190.516 186.882 190.52 186.693 190.714L169.738 208.102V188.684C169.738 188.577 169.702 188.472 169.636 188.386L169.514 188.226V171.927C169.648 171.84 169.738 171.688 169.738 171.515V168.903L186.407 147.13C186.572 146.915 186.531 146.607 186.316 146.442C186.101 146.277 185.793 146.318 185.628 146.533L169.738 167.288V144.692C169.738 144.584 169.702 144.48 169.636 144.394L169.514 144.234Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M79.441 242.47C55.3927 242.47 35.8977 222.477 35.8977 197.816C35.8977 173.154 55.3927 42.5527 79.441 42.5527C103.489 42.5527 122.984 173.154 122.984 197.816C122.984 222.477 103.489 242.47 79.441 242.47Z"
        fill="#BFEAFF"
      />
      <path
        opacity="0.4"
        d="M79.3068 183.906V164.875L96.2002 142.81C96.365 142.595 96.3241 142.286 96.1089 142.122C95.8936 141.957 95.5855 141.998 95.4207 142.213L78.4262 164.41C78.3606 164.496 78.3251 164.601 78.3251 164.708V182.623L62.4349 161.869C62.2701 161.653 61.962 161.613 61.7467 161.777C61.5315 161.942 61.4906 162.25 61.6554 162.465L78.3251 184.238V191.531C78.3251 191.704 78.4141 191.856 78.5488 191.943V205.475L62.4349 184.428C62.2701 184.213 61.962 184.172 61.7467 184.337C61.5315 184.502 61.4906 184.81 61.6554 185.025L78.5488 207.09V227.365C78.5005 227.442 78.4744 227.532 78.4744 227.624V267.114C78.4744 267.385 78.6942 267.605 78.9653 267.605C79.2363 267.605 79.4561 267.385 79.4561 267.114V234.007C79.5032 233.931 79.5305 233.842 79.5305 233.747V227.748L97.1887 209.639C97.378 209.445 97.374 209.134 97.18 208.945C96.9859 208.756 96.6751 208.76 96.4858 208.954L79.5305 226.342V206.924V184.364C79.5305 184.256 79.4949 184.151 79.4294 184.066L79.3068 183.906Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M434.605 255.307C410.557 255.307 391.062 235.314 391.062 210.653C391.062 185.991 410.557 55.3896 434.605 55.3896C458.653 55.3896 478.148 185.991 478.148 210.653C478.148 235.314 458.653 255.307 434.605 255.307Z"
        fill="#8FD8FC"
      />
      <path
        opacity="0.4"
        d="M434.471 196.743V177.712L451.364 155.647C451.529 155.431 451.488 155.123 451.273 154.959C451.058 154.794 450.75 154.835 450.585 155.05L433.59 177.247C433.525 177.333 433.489 177.438 433.489 177.545V195.46L417.599 174.706C417.434 174.49 417.126 174.449 416.911 174.614C416.696 174.779 416.655 175.087 416.819 175.302L433.489 197.075V204.368C433.489 204.541 433.578 204.693 433.713 204.78V218.312L417.599 197.265C417.434 197.05 417.126 197.009 416.911 197.174C416.696 197.339 416.655 197.647 416.819 197.862L433.713 219.927V240.202C433.665 240.279 433.638 240.369 433.638 240.461V279.951C433.638 280.222 433.858 280.442 434.129 280.442C434.4 280.442 434.62 280.222 434.62 279.951V246.844C434.667 246.768 434.695 246.679 434.695 246.584V240.585L452.353 222.476C452.542 222.282 452.538 221.971 452.344 221.782C452.15 221.593 451.839 221.597 451.65 221.791L434.695 239.179V219.761V197.201C434.695 197.093 434.659 196.988 434.593 196.903L434.471 196.743Z"
        fill="white"
      />
      <path
        d="M344.528 81.238L341.405 80.544L340.711 77.4208C340.672 77.3051 340.595 77.228 340.48 77.228C340.364 77.228 340.287 77.3051 340.248 77.4208L339.554 80.544L336.431 81.2766C336.315 81.3151 336.238 81.3923 336.238 81.5079C336.238 81.6236 336.315 81.7006 336.431 81.7391L339.554 82.4333L340.248 85.5565C340.287 85.6721 340.364 85.7492 340.48 85.7492C340.595 85.7492 340.672 85.6721 340.711 85.5565L341.405 82.4333L344.528 81.7007C344.644 81.6622 344.721 81.585 344.721 81.4693C344.721 81.3537 344.605 81.2765 344.528 81.238Z"
        fill="#3C7E52"
      />
      <path
        d="M170.129 94.7716L174.448 93.8463L175.412 89.5664C175.45 89.4121 175.566 89.2964 175.72 89.2964C175.874 89.2964 176.029 89.4121 176.029 89.5664L176.992 93.8847L181.311 94.8872C181.465 94.9258 181.581 95.0414 181.581 95.2342C181.581 95.3884 181.465 95.5428 181.311 95.5428L176.992 96.4681L176.029 100.748C175.99 100.902 175.874 101.018 175.72 101.018C175.566 101.018 175.412 100.902 175.412 100.748L174.448 96.4295L170.129 95.427C169.975 95.3884 169.859 95.2728 169.859 95.08C169.859 94.9643 169.975 94.8102 170.129 94.7716Z"
        fill="#3C7E52"
      />
      <path
        d="M188.178 58.5662L190.414 58.0648L190.915 55.8286C190.915 55.7515 190.992 55.7129 191.069 55.7129C191.147 55.7129 191.224 55.7515 191.224 55.8286L191.725 58.0648L193.961 58.6046C194.038 58.6046 194.077 58.6819 194.077 58.759C194.077 58.8361 194.038 58.9132 193.923 58.9132L191.686 59.4143L191.185 61.6508C191.185 61.7279 191.108 61.7664 191.031 61.7664C190.954 61.7664 190.877 61.7279 190.877 61.6508L190.375 59.4143L188.139 58.8746C188.062 58.8746 188.023 58.7975 188.023 58.7204C188.023 58.6433 188.101 58.5662 188.178 58.5662Z"
        fill="#3C7E52"
      />
      <path
        d="M149.039 162.517L165.195 304.871H360.758L376.952 162.517H149.039Z"
        fill="#45F882"
      />
      <path
        d="M361.798 306.027H164.191L164.076 304.986L147.766 161.321H378.223L378.069 162.594L361.798 306.027ZM166.235 303.714H359.716L375.64 163.673H150.31L166.235 303.714Z"
        fill="#3C7E52"
      />
      <path
        d="M149.427 146.747H376.915C384.28 146.747 390.256 152.723 390.256 160.087C390.256 167.452 384.28 173.428 376.915 173.428H149.427C142.062 173.428 136.086 167.452 136.086 160.087C136.086 152.684 142.062 146.747 149.427 146.747Z"
        fill="#45F882"
      />
      <path
        d="M376.955 174.585H149.466C141.485 174.585 134.969 168.069 134.969 160.087C134.969 152.106 141.485 145.59 149.466 145.59H376.955C384.936 145.59 391.452 152.106 391.452 160.087C391.452 168.069 384.936 174.585 376.955 174.585ZM149.428 147.865C142.719 147.865 137.244 153.34 137.244 160.049C137.244 166.758 142.719 172.233 149.428 172.233H376.916C383.625 172.233 389.101 166.758 389.101 160.049C389.101 153.34 383.625 147.865 376.916 147.865H149.428Z"
        fill="#3C7E52"
      />
      <path
        d="M242.346 80.8135L196.077 157.581C194.689 159.856 195.421 162.825 197.735 164.213L206.603 169.573C208.878 170.961 211.847 170.228 213.235 167.915L259.504 91.147C260.892 88.8721 260.159 85.9032 257.845 84.5151L248.977 79.1556C246.702 77.8061 243.734 78.5387 242.346 80.8135Z"
        fill="#45F882"
      />
      <path
        d="M209.109 171.423C208.03 171.423 206.989 171.115 206.025 170.575L197.157 165.216C195.769 164.406 194.805 163.095 194.419 161.514C194.033 159.972 194.265 158.353 195.113 157.003L241.382 80.2352C242.192 78.8472 243.503 77.8832 245.084 77.4976C246.626 77.112 248.245 77.3435 249.595 78.1918L258.463 83.5512C259.851 84.3609 260.815 85.6719 261.2 87.2527C261.586 88.795 261.355 90.4143 260.507 91.7638L214.238 168.532C213.428 169.92 212.117 170.884 210.536 171.269C210.073 171.385 209.572 171.423 209.109 171.423ZM246.471 79.6569C246.163 79.6569 245.893 79.6955 245.585 79.7726C244.621 80.004 243.811 80.6208 243.31 81.4305L197.041 158.198C196.54 159.047 196.385 160.01 196.617 160.974C196.848 161.938 197.465 162.748 198.275 163.249L207.143 168.609C208.878 169.65 211.153 169.11 212.194 167.375L258.463 90.6071C258.964 89.7589 259.118 88.795 258.887 87.8311C258.656 86.8672 258.039 86.0575 257.229 85.5563L248.361 80.1966C247.783 79.811 247.166 79.6569 246.471 79.6569Z"
        fill="#3C7E52"
      />
      <path
        d="M281.598 80.8131L327.867 157.581C329.255 159.856 328.522 162.825 326.209 164.213L317.341 169.572C315.066 170.96 312.097 170.228 310.709 167.914L264.44 91.1465C263.052 88.8717 263.785 85.9027 266.098 84.5146L274.966 79.1552C277.241 77.8057 280.21 78.5382 281.598 80.8131Z"
        fill="#45F882"
      />
      <path
        d="M314.835 171.423C312.791 171.423 310.824 170.382 309.706 168.531L263.437 91.7636C262.628 90.3755 262.358 88.7948 262.743 87.2525C263.129 85.7102 264.093 84.3992 265.481 83.551L274.349 78.1915C275.737 77.3818 277.318 77.1118 278.86 77.4974C280.403 77.8829 281.714 78.8469 282.562 80.235L328.831 157.003C329.641 158.391 329.911 159.972 329.525 161.514C329.139 163.056 328.175 164.367 326.787 165.215L317.919 170.575C316.955 171.153 315.914 171.423 314.835 171.423ZM277.434 79.6566C276.778 79.6566 276.123 79.8494 275.545 80.1964L266.676 85.556C265.828 86.0573 265.25 86.8669 265.018 87.8309C264.787 88.7948 264.941 89.7586 265.443 90.6069L311.711 167.375C312.752 169.11 315.027 169.688 316.762 168.609L325.631 163.249C326.479 162.748 327.057 161.938 327.289 160.974C327.52 160.01 327.366 159.046 326.864 158.198L280.595 81.4303C280.094 80.582 279.285 80.0037 278.321 79.7724C278.051 79.6953 277.742 79.6566 277.434 79.6566Z"
        fill="#3C7E52"
      />
      <path
        d="M207.88 163.095C211.117 163.095 213.741 160.471 213.741 157.234C213.741 153.998 211.117 151.374 207.88 151.374C204.644 151.374 202.02 153.998 202.02 157.234C202.02 160.471 204.644 163.095 207.88 163.095Z"
        fill="#0B0E13"
      />
      <path
        d="M207.881 164.252C204.025 164.252 200.863 161.09 200.863 157.234C200.863 153.379 204.025 150.217 207.881 150.217C211.737 150.217 214.898 153.379 214.898 157.234C214.898 161.129 211.737 164.252 207.881 164.252ZM207.881 152.53C205.297 152.53 203.177 154.651 203.177 157.234C203.177 159.818 205.297 161.938 207.881 161.938C210.464 161.938 212.585 159.818 212.585 157.234C212.585 154.651 210.464 152.53 207.881 152.53Z"
        fill="#3C7E52"
      />
      <path
        d="M315.455 162.709C318.691 162.709 321.315 160.085 321.315 156.849C321.315 153.612 318.691 150.988 315.455 150.988C312.218 150.988 309.594 153.612 309.594 156.849C309.594 160.085 312.218 162.709 315.455 162.709Z"
        fill="#0B0E13"
      />
      <path
        d="M315.455 163.866C311.599 163.866 308.438 160.704 308.438 156.849C308.438 152.993 311.599 149.831 315.455 149.831C319.311 149.831 322.472 152.993 322.472 156.849C322.472 160.704 319.349 163.866 315.455 163.866ZM315.455 152.144C312.872 152.144 310.751 154.265 310.751 156.849C310.751 159.432 312.872 161.552 315.455 161.552C318.038 161.552 320.159 159.432 320.159 156.849C320.159 154.265 318.077 152.144 315.455 152.144Z"
        fill="#3C7E52"
      />
      <path
        d="M195.542 186.962H181.777V233.462H195.542V186.962Z"
        fill="#0B0E13"
      />
      <path
        d="M233.558 186.962H219.793V233.462H233.558V186.962Z"
        fill="#0B0E13"
      />
      <path
        d="M234.715 234.657H218.637V185.844H234.715V234.657ZM220.95 232.344H232.402V188.157H220.95V232.344Z"
        fill="#3C7E52"
      />
      <path
        d="M271.573 186.962H257.809V233.462H271.573V186.962Z"
        fill="#0B0E13"
      />
      <path
        d="M309.21 186.962H295.445V233.462H309.21V186.962Z"
        fill="#0B0E13"
      />
      <path
        d="M347.226 186.962H333.461V233.462H347.226V186.962Z"
        fill="#0B0E13"
      />
      <path
        d="M195.542 243.988H181.777V290.489H195.542V243.988Z"
        fill="#0B0E13"
      />
      <path
        d="M233.558 243.988H219.793V290.489H233.558V243.988Z"
        fill="#0B0E13"
      />
      <path
        d="M271.577 243.988H257.812V290.489H271.577V243.988Z"
        fill="#0B0E13"
      />
      <path
        d="M309.206 243.988H295.441V290.489H309.206V243.988Z"
        fill="#0B0E13"
      />
      <path
        d="M347.226 243.988H333.461V290.489H347.226V243.988Z"
        fill="#0B0E13"
      />
      <path
        d="M373.139 197.796C394.924 197.796 412.584 180.137 412.584 158.352C412.584 136.568 394.924 118.908 373.139 118.908C351.355 118.908 333.695 136.568 333.695 158.352C333.695 180.137 351.355 197.796 373.139 197.796Z"
        fill="white"
      />
      <path
        d="M373.14 198.953C350.777 198.953 332.539 180.754 332.539 158.352C332.539 135.95 350.738 117.751 373.14 117.751C395.542 117.751 413.741 135.95 413.741 158.352C413.741 180.754 395.542 198.953 373.14 198.953ZM373.14 120.103C352.049 120.103 334.853 137.261 334.853 158.391C334.853 179.52 352.01 196.678 373.14 196.678C394.269 196.678 411.428 179.52 411.428 158.391C411.428 137.261 394.269 120.103 373.14 120.103Z"
        fill="#3C7E52"
      />
      <path
        d="M396.501 70.9043H394.188V111.351H396.501V70.9043Z"
        fill="#3C7E52"
      />
      <path
        d="M441.954 90.1298L413.227 118.048L414.839 119.707L443.567 91.7887L441.954 90.1298Z"
        fill="#3C7E52"
      />
      <path
        d="M462.285 135.874H421.453V138.187H462.285V135.874Z"
        fill="#3C7E52"
      />
      <path
        d="M364.851 175.858C362.421 174.315 360.532 172.002 359.105 169.033C357.717 166.026 357.023 162.478 357.023 158.391C357.023 154.266 357.717 150.718 359.105 147.749C360.494 144.742 362.421 142.467 364.851 140.925C367.28 139.382 370.017 138.573 373.102 138.573C376.187 138.573 378.963 139.344 381.392 140.925C383.821 142.467 385.749 144.78 387.137 147.749C388.525 150.757 389.219 154.304 389.219 158.391C389.219 162.517 388.525 166.064 387.137 169.033C385.749 172.041 383.821 174.315 381.392 175.858C378.963 177.4 376.187 178.21 373.102 178.21C370.056 178.21 367.28 177.4 364.851 175.858ZM379.657 168.57C381.238 166.295 382.047 162.902 382.047 158.391C382.047 153.88 381.238 150.487 379.657 148.212C378.076 145.937 375.878 144.78 373.14 144.78C370.441 144.78 368.282 145.937 366.663 148.212C365.082 150.487 364.272 153.88 364.272 158.391C364.272 162.902 365.082 166.295 366.663 168.57C368.244 170.845 370.403 172.002 373.14 172.002C375.878 171.963 378.037 170.845 379.657 168.57Z"
        fill="#45F882"
      />
      <path
        d="M373.141 179.366C369.825 179.366 366.856 178.518 364.234 176.86C361.651 175.202 359.569 172.735 358.065 169.534C356.6 166.411 355.867 162.633 355.867 158.391C355.867 154.111 356.6 150.371 358.065 147.248C359.53 144.086 361.612 141.619 364.234 139.922C366.818 138.264 369.825 137.416 373.141 137.416C376.418 137.416 379.426 138.264 382.048 139.922C384.67 141.58 386.752 144.048 388.217 147.248C389.682 150.371 390.415 154.15 390.415 158.391C390.415 162.671 389.682 166.411 388.217 169.534C386.752 172.735 384.67 175.164 382.048 176.86C379.426 178.518 376.418 179.366 373.141 179.366ZM373.141 139.691C370.288 139.691 367.743 140.423 365.507 141.85C363.27 143.277 361.497 145.436 360.186 148.212C358.875 151.027 358.219 154.458 358.219 158.391C358.219 162.324 358.875 165.756 360.186 168.57C361.497 171.346 363.27 173.467 365.507 174.932C367.743 176.359 370.288 177.092 373.141 177.092C375.994 177.092 378.578 176.359 380.814 174.932C383.05 173.506 384.862 171.346 386.135 168.57C387.446 165.756 388.101 162.324 388.101 158.391C388.101 154.458 387.446 151.065 386.135 148.212C384.824 145.436 383.05 143.315 380.814 141.85C378.539 140.423 375.956 139.691 373.141 139.691ZM373.141 173.12C370.018 173.12 367.55 171.809 365.738 169.226C364.003 166.758 363.116 163.095 363.116 158.353C363.116 153.61 364.003 149.947 365.738 147.479C367.55 144.896 370.056 143.585 373.141 143.585C376.264 143.585 378.809 144.896 380.621 147.479C382.356 149.947 383.243 153.61 383.243 158.353C383.243 163.095 382.356 166.758 380.621 169.226C378.77 171.809 376.264 173.12 373.141 173.12ZM373.141 145.899C370.789 145.899 368.977 146.862 367.627 148.829C366.162 150.911 365.429 154.111 365.429 158.353C365.429 162.594 366.162 165.794 367.627 167.876C369.015 169.843 370.827 170.807 373.141 170.807C375.531 170.807 377.344 169.843 378.732 167.876C380.197 165.794 380.929 162.594 380.929 158.353C380.929 154.111 380.197 150.911 378.732 148.829C377.344 146.862 375.493 145.899 373.141 145.899Z"
        fill="#3C7E52"
      />
      <path
        d="M337.527 331.353C333.44 324.853 324.113 321.603 309.546 321.603C287.696 321.603 291.595 309.811 268.935 309.811C246.276 309.811 259.891 265.247 204.798 262.89C149.704 260.532 162.176 288.829 145.182 288.829C128.187 288.829 119.049 274.963 98.2445 275.943C77.4396 276.922 69.0473 308.051 60.6849 309.811C52.3225 311.571 58.5269 303.652 35.5977 303.652C20.3117 303.652 9.52147 309.635 3.2272 321.603C-5.5423 328.103 3.56068 331.353 30.5361 331.353C40.4673 331.353 67.8201 328.186 98.2445 327.305C115.414 326.808 146.761 336.281 186.184 336.281C204.798 336.281 220.748 332.049 257.13 331.353C281.385 330.889 308.184 330.889 337.527 331.353Z"
        fill="#0D152E"
      />
    </svg>
  );
}

function EmptyCart() {
  const router = useRouter();
  return (
    <div className="w-full">
      <div className="w-full flex justify-center mb-5">
        <Svg />
      </div>
      <p className="text-center font-semibold text-[26px] text-white mb-6">
        <StringLang string="No Result Found" />
      </p>
      <div className="w-full flex justify-center">
        <button onClick={() => router.back()} type="button">
          <div className="py-4 px-8 flex rtl:space-x-reverse space-x-2.5 items-center bg-primary-blue group  hover:bg-white hover:text-black  common-transition rounded-[5px]">
            <span className="text-primary-black  common-transition group-hover:text-black text-base font-medium leading-5">
              <StringLang string="Go Back!" />
            </span>
          </div>
        </button>
      </div>
    </div>
  );
}

export default EmptyCart;
