"use client";

import React, { useState } from "react";
import Modal from "@/components/Helper/Modal";
import {
  useApproveOrderMutation,
  useGetOrderQuery,
} from "@/store/features/order/apiSlice";
import PaginateObserver from "@/components/Helper/PaginateObserver";
import { useDispatch, useSelector } from "react-redux";
import { ordersPageIncrease } from "@/store/features/pagination/paginationSlice";
import ReviewModal from "@/components/Helper/ReviewModal";
import OrderChatBoard from "@/components/Helper/OrderChatBoard";
import StringLang from "@/utilities/StringLang";
import useCurrency from "@/hooks/useCurrency";
import Link from "next/link";

function OrderTab() {
  const [toogleModal, setToogleModal] = useState(false);
  const [orderViewType, setOrderViewType] = useState("list");

  const page = useSelector((state) => state?.pagination?.ordersPage);
  const dispatch = useDispatch();

  const { data, isFetching } = useGetOrderQuery({ page });

  const paginationHandler = () => {
    dispatch(ordersPageIncrease());
  };

  const [approveOrder, { isLoading }] = useApproveOrderMutation();
  const calculatePrice = useCurrency();

  return (
    <div className="w-full md:px-10 md:py-7 p-5 bg-black rounded-md">
      {/* ================= ORDER LIST ================= */}
      {orderViewType === "list" && (
        <div className="w-full">
          <p className="text-[24px] font-semibold text-white leading-8 mb-[18px]">
            <StringLang string="My Order" />
          </p>

          <PaginateObserver
            type="onclick"
            handler={paginationHandler}
            currentPage={page}
            lastPage={data?.items?.last_page}
            loading={isFetching}
          >
            <div className="flex flex-col space-y-[18px]">
              {data?.items?.data.map((item) => (
                <div
                  key={item.id}
                  className="w-full rounded p-2.5 border border-[#3C3E42] bg-[#0B0E12]"
                >
                  <div className="grid md:grid-cols-2 gap-5 items-center">
                    <div className="flex md:flex-row flex-col gap-4">
                      <div className="md:w-[160px] w-full h-[130px] rounded overflow-hidden">
                        <img
                          src={process.env.BASE_URL + item.variant_image}
                          alt=""
                          className="w-full h-full object-cover"
                        />
                      </div>

                      {/* 🔧 SHIFTED RIGHT ~10% */}
                      <div className="pl-[10%]">
                        <span className="text-lg font-semibold text-primary-blue block">
                          {calculatePrice(Number(item?.option_price))}
                        </span>

                        <h1 className="text-[22px] text-white font-medium">
                          {item?.variant_name}
                        </h1>

                        <p className="text-primary-blue text-base break-all">
  Order ID: #{item?.order_id}
</p>
                      </div>
                    </div>

                    <div className="flex justify-end">
                      <button
                        onClick={() => setOrderViewType(item)}
                        className="px-6 py-3 bg-primary-blue rounded-lg"
                      >
                        <span className="text-black font-semibold">
                          <StringLang string="Get Info" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </PaginateObserver>
        </div>
      )}

      {/* ================= ORDER DETAILS ================= */}
      {orderViewType !== "list" && orderViewType?.id && (
        <>
          <div className="flex items-center space-x-2.5 mb-4">
            <button onClick={() => setOrderViewType("list")}>⬅</button>
            <p className="text-[24px] font-semibold text-white">
              <StringLang string="Order Message" />
            </p>
          </div>

          <div className="w-full flex xl:flex-row flex-col-reverse gap-[30px]">
            {/* CHAT */}
            <div className="flex-1">
              <OrderChatBoard
                id={orderViewType?.id}
                isApprove={orderViewType?.approve_by_user === "approved"}
              />
            </div>

            {/* ORDER INFO */}
            <div className="xl:w-[260px] w-full xl:border-l border-[#23262B]">
              <div>
                <p className="text-base font-semibold text-white mb-3">
                  <StringLang string="Order Info" />
                </p>

                <img
                  src={process.env.BASE_URL + orderViewType.variant_image}
                  alt=""
                  className="w-full h-[170px] object-cover rounded-lg mb-4"
                />

                {/* 🔧 SHIFTED RIGHT ~10% */}
                <div className="pl-[10%]">
                  <span className="text-lg font-semibold text-primary-blue block">
                    {calculatePrice(Number(orderViewType?.option_price))}
                  </span>

                  <h1 className="text-[22px] text-white mt-1">
                    {orderViewType?.option_name}
                  </h1>

                  <p className="text-white text-sm mb-4">
                    Order ID: #{orderViewType?.order_id}
                  </p>
                </div>

                {/* ACTION BUTTONS */}
                <div className="w-full grid place-items-center mt-5">
                  <div className="w-full max-w-[240px] flex flex-col gap-5">
                    <div className="w-full h-[52px] flex justify-center items-center border border-primary-blue rounded-xl">
                      <span className="text-white text-base font-semibold">
                        Gekauft
                      </span>
                    </div>

                    {orderViewType?.approve_by_user !== "approved" && (
                      <button
                        disabled={isLoading}
                        onClick={() =>
                          approveOrder({
                            orderId: orderViewType.id,
                            reSet: () => setOrderViewType("list"),
                          })
                        }
                        className="w-full h-[56px] bg-primary-blue rounded-xl hover:bg-white transition flex justify-center items-center"
                      >
                        <span className="text-black text-lg font-semibold">
                          Erhalt bestätigen
                        </span>
                      </button>
                    )}

                    {/* SUPPORT TICKET */}
                    <Link
                      href="/auth/profile/tickets"
                      className="w-full h-[52px] border border-[#FFB321] rounded-xl flex justify-center items-center hover:bg-[#FFB321] transition"
                    >
                      <span className="text-white hover:text-black font-semibold">
                        Support Ticket erstellen
                      </span>
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </>
      )}

      {/* REVIEW MODAL */}
      {toogleModal && (
        <Modal onClose={() => setToogleModal(false)}>
          <ReviewModal
            orderId={toogleModal}
            close={() => setToogleModal(false)}
          />
        </Modal>
      )}
    </div>
  );
}

export default OrderTab;
